/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.handlers;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class CxfUndertowLogHandler
implements CXFUndertowHttpHandler {
    private HttpHandler next;
    private AccessLogHandler accessLogHandler;
    private String pattern;
    private String outPutDirectory;
    private String baseName;
    private String suffix;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.accessLogHandler == null) {
            this.buildLogHandler();
        }
        this.accessLogHandler.handleRequest(exchange);
    }

    @Override
    public void setNext(HttpHandler nextHandler) {
        this.next = nextHandler;
    }

    private void buildLogHandler() {
        HttpHandler handler = this.next;
        XnioWorker xnioWorker = CxfUndertowLogHandler.createWorker(this.getClass().getClassLoader());
        if (this.getOutPutDirectory() == null) {
            this.setOutPutDirectory("./data/log");
        }
        if (this.getBaseName() == null) {
            this.setBaseName("request.");
        }
        if (this.getSuffix() == null) {
            this.setSuffix("log");
        }
        if (this.getPattern() == null) {
            this.setPattern("combined");
        }
        DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)xnioWorker).setOutputDirectory(new File(this.getOutPutDirectory()).toPath()).setLogBaseName(this.getBaseName()).setLogNameSuffix(this.getSuffix()).setRotate(true).build();
        this.accessLogHandler = new AccessLogHandler(handler, (AccessLogReceiver)logReceiver, this.getPattern(), AccessLogHandler.class.getClassLoader());
    }

    public static XnioWorker createWorker(ClassLoader loader) {
        try {
            if (loader == null) {
                loader = Undertow.class.getClassLoader();
            }
            Xnio xnio = Xnio.getInstance((ClassLoader)loader);
            return xnio.createWorker(OptionMap.builder().set(Options.THREAD_DAEMON, true).getMap());
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getOutPutDirectory() {
        return this.outPutDirectory;
    }

    public void setOutPutDirectory(String outPutDirectory) {
        this.outPutDirectory = outPutDirectory;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

