/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.claims.ClaimsSecurityContext;

public class JwtTokenSecurityContext
implements ClaimsSecurityContext {
    private final JwtToken token;
    private final Principal principal;
    private final Set<Principal> roles;
    private final ClaimCollection claims = new ClaimCollection();

    public JwtTokenSecurityContext(JwtToken jwt, String roleClaim) {
        this.principal = new SimplePrincipal(jwt.getClaims().getSubject());
        this.token = jwt;
        if (roleClaim != null && jwt.getClaims().containsProperty(roleClaim)) {
            Object roleClaimValue = jwt.getClaims().getClaim(roleClaim);
            if (!(roleClaimValue instanceof List)) {
                this.roles = new HashSet<Principal>();
                String role = jwt.getClaims().getStringProperty(roleClaim).trim();
                for (String r : role.split(",")) {
                    this.roles.add((Principal)new SimpleGroup(r));
                }
            } else if (roleClaimValue instanceof List && ((List)roleClaimValue).stream().noneMatch(o -> !(o instanceof String))) {
                this.roles = new HashSet<Principal>();
                ((List)roleClaimValue).stream().forEach(val -> this.roles.add((Principal)new SimpleGroup(val.toString())));
            } else {
                this.roles = Collections.emptySet();
            }
        } else {
            this.roles = Collections.emptySet();
        }
        jwt.getClaims().asMap().forEach((name, values) -> {
            Claim claim = new Claim();
            claim.setClaimType(name);
            if (values instanceof List) {
                claim.setValues(CastUtils.cast((List)((List)values)));
            } else {
                claim.setValues(Collections.singletonList(values));
            }
            this.claims.add((Object)claim);
        });
    }

    public JwtToken getToken() {
        return this.token;
    }

    public Subject getSubject() {
        return null;
    }

    public Set<Principal> getUserRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        for (Principal principalRole : this.roles) {
            if (principalRole == this.principal || !principalRole.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    public ClaimCollection getClaims() {
        return this.claims;
    }
}

