/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;

public class ReportingSet<T>
implements SortedSet<T> {
    private final SortedSet<T> delegate;
    private Options duplicateOption = Options.IGNORE;
    private Log.Level duplicateLogLevel = Log.Level.WARN;
    private Log log = DefaultLog.INSTANCE;
    private Function<T, String> duplicateFmt = t -> String.format("Duplicate %s (%s) detected %s", t.getClass(), t);

    public ReportingSet() {
        this(new TreeSet());
    }

    public ReportingSet(SortedSet<T> delegate) {
        this.delegate = delegate;
    }

    public ReportingSet<T> setMsgFormat(Function<T, String> msgFmt) {
        this.duplicateFmt = msgFmt;
        return this;
    }

    public ReportingSet<T> setDuplicateOption(Options state) {
        this.duplicateOption = state;
        return this;
    }

    public ReportingSet<T> setLog(Log log) {
        this.log = log;
        return this;
    }

    public ReportingSet<T> setLogLevel(Log.Level level) {
        this.duplicateLogLevel = level;
        return this;
    }

    private ReportingSet<T> sameConfig(SortedSet<T> delegate) {
        ReportingSet<T> result = delegate instanceof ReportingSet ? (ReportingSet<T>)delegate : new ReportingSet<T>(delegate);
        return result.setDuplicateOption(this.duplicateOption).setLog(this.log).setLogLevel(this.duplicateLogLevel);
    }

    public boolean addIfNotPresent(T e) {
        return this.add(false, e);
    }

    @Override
    public boolean add(T e) {
        return this.add(true, e);
    }

    private boolean add(boolean reportDup, T e) {
        if (this.delegate.contains(e)) {
            String msg = String.format("%s", this.duplicateFmt.apply(e));
            if (reportDup) {
                msg = String.format("%s (action: %s)", new Object[]{msg, this.duplicateOption});
                this.log.log(this.duplicateLogLevel, msg);
            }
            switch (this.duplicateOption) {
                case FAIL: {
                    throw new IllegalArgumentException(msg);
                }
                case IGNORE: {
                    return false;
                }
                case OVERWRITE: {
                    this.delegate.remove(e);
                    return this.delegate.add(e);
                }
            }
        }
        return this.delegate.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean updated = false;
        for (T e : c) {
            updated |= this.add(e);
        }
        return updated;
    }

    public boolean addAllIfNotPresent(Collection<? extends T> c) {
        boolean updated = false;
        for (T e : c) {
            updated |= this.addIfNotPresent(e);
        }
        return updated;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public T first() {
        return this.delegate.first();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public ReportingSet<T> headSet(T toElement) {
        return this.sameConfig(this.delegate.headSet(toElement));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public T last() {
        return this.delegate.last();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.delegate.stream();
    }

    @Override
    public ReportingSet<T> subSet(T fromElement, T toElement) {
        return this.sameConfig(this.delegate.subSet(fromElement, toElement));
    }

    @Override
    public ReportingSet<T> tailSet(T fromElement) {
        return this.sameConfig(this.delegate.tailSet(fromElement));
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    public static enum Options {
        OVERWRITE,
        IGNORE,
        FAIL;

    }
}

