/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.rat.api.Document;
import org.apache.rat.document.impl.AbstractMonolithicDocument;
import org.apache.rat.document.impl.DocumentImplUtils;

public class MonolithicFileDocument
extends AbstractMonolithicDocument {
    private static final String FILE_URL_PREFIX = "file";
    private final File file;

    public static Document newInstance(final URL url) {
        if (FILE_URL_PREFIX.equals(url.getProtocol())) {
            File f = new File(url.getFile());
            return new MonolithicFileDocument(f);
        }
        return new AbstractMonolithicDocument(url.toExternalForm()){

            @Override
            public Reader reader() throws IOException {
                return new InputStreamReader(this.inputStream(), StandardCharsets.UTF_8);
            }

            @Override
            public InputStream inputStream() throws IOException {
                return url.openStream();
            }
        };
    }

    public MonolithicFileDocument(File file) {
        super(DocumentImplUtils.toName(file));
        this.file = file;
    }

    @Override
    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

