/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.rat.annotation.BOMInputStream;
import org.apache.rat.utils.Log;

public abstract class AbstractLicenseAppender {
    private static final String DOT = ".";
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_JAVA = 1;
    private static final int TYPE_XML = 2;
    private static final int TYPE_HTML = 3;
    private static final int TYPE_CSS = 4;
    private static final int TYPE_JAVASCRIPT = 5;
    private static final int TYPE_APT = 6;
    private static final int TYPE_PROPERTIES = 7;
    private static final int TYPE_PYTHON = 8;
    private static final int TYPE_C = 9;
    private static final int TYPE_H = 10;
    private static final int TYPE_SH = 11;
    private static final int TYPE_BAT = 12;
    private static final int TYPE_VM = 13;
    private static final int TYPE_SCALA = 14;
    private static final int TYPE_RUBY = 15;
    private static final int TYPE_PERL = 16;
    private static final int TYPE_TCL = 17;
    private static final int TYPE_CPP = 18;
    private static final int TYPE_CSHARP = 19;
    private static final int TYPE_PHP = 20;
    private static final int TYPE_GROOVY = 21;
    private static final int TYPE_VISUAL_STUDIO_SOLUTION = 22;
    private static final int TYPE_BEANSHELL = 23;
    private static final int TYPE_JSP = 24;
    private static final int TYPE_FML = 25;
    private static final int TYPE_GO = 26;
    private static final int TYPE_PM = 27;
    private static final int TYPE_MD = 28;
    private static final int TYPE_YAML = 29;
    private static final String LINE_SEP = System.lineSeparator();
    private static final int[] FAMILY_C = new int[]{1, 5, 9, 10, 14, 4, 18, 19, 20, 21, 23, 26};
    private static final int[] FAMILY_SGML = new int[]{2, 3, 24, 25, 28};
    private static final int[] FAMILY_SH = new int[]{7, 8, 11, 15, 16, 17, 22, 27, 29};
    private static final int[] FAMILY_BAT = new int[]{12};
    private static final int[] FAMILY_APT = new int[]{6};
    private static final int[] FAMILY_VELOCITY = new int[]{13};
    private static final int[] EXPECTS_HASH_PLING = new int[]{8, 11, 15, 16, 17};
    private static final int[] EXPECTS_AT_ECHO = new int[]{12};
    private static final int[] EXPECTS_PACKAGE = new int[]{1, 26, 27};
    private static final int[] EXPECTS_XML_DECL = new int[]{2};
    private static final int[] EXPECTS_PHP_PI = new int[]{20};
    private static final int[] EXPECTS_MSVSSF_HEADER = new int[]{22};
    private static final Map<String, Integer> EXT2TYPE = new HashMap<String, Integer>();
    private boolean isForced;
    private final Log log;

    public AbstractLicenseAppender(Log log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(File document) throws IOException {
        int type = this.getType(document);
        if (type == 0) {
            return;
        }
        boolean expectsHashPling = AbstractLicenseAppender.expectsHashPling(type);
        boolean expectsAtEcho = AbstractLicenseAppender.expectsAtEcho(type);
        boolean expectsPackage = AbstractLicenseAppender.expectsPackage(type);
        boolean expectsXMLDecl = AbstractLicenseAppender.expectsXMLDecl(type);
        boolean expectsPhpPI = AbstractLicenseAppender.expectsPhpPI(type);
        boolean expectsMSVSSF = AbstractLicenseAppender.expectsMSVisualStudioSolutionFileHeader(type);
        File newDocument = new File(document.getAbsolutePath() + ".new");
        FileWriter writer = new FileWriter(newDocument);
        try {
            if (!this.attachLicense(writer, document, expectsHashPling, expectsAtEcho, expectsPackage, expectsXMLDecl, expectsPhpPI, expectsMSVSSF) && (expectsPackage || expectsXMLDecl)) {
                writer = new FileWriter(newDocument);
                if (expectsXMLDecl) {
                    writer.write("<?xml version='1.0'?>");
                    writer.write(LINE_SEP);
                }
                this.attachLicense(writer, document, false, false, false, false, false, false);
            }
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
        if (this.isForced) {
            boolean renamed;
            boolean deleted = document.delete();
            if (!deleted) {
                this.log.error("Could not delete original file to prepare renaming.");
            }
            if (!(renamed = newDocument.renameTo(document.getAbsoluteFile()))) {
                this.log.error("Failed to rename new file, original file remains unchanged.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachLicense(Writer writer, File document, boolean expectsHashPling, boolean expectsAtEcho, boolean expectsPackage, boolean expectsXMLDecl, boolean expectsPhpPI, boolean expectsMSVSSF) throws IOException {
        boolean written = false;
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(document);
            br = new BufferedReader(new InputStreamReader(new BOMInputStream(fis)));
            if (!(expectsHashPling || expectsAtEcho || expectsPackage || expectsXMLDecl || expectsPhpPI || expectsMSVSSF)) {
                written = true;
                writer.write(this.getLicenseHeader(document));
                writer.write(LINE_SEP);
            }
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first && expectsHashPling) {
                    written = true;
                    this.doFirstLine(document, writer, line, "#!");
                } else if (first && expectsAtEcho) {
                    written = true;
                    this.doFirstLine(document, writer, line, "@echo");
                } else if (first && expectsMSVSSF) {
                    written = true;
                    if (line.isEmpty()) {
                        line = this.passThroughReadNext(writer, line, br);
                    }
                    if (line.startsWith("Microsoft Visual Studio Solution File")) {
                        line = this.passThroughReadNext(writer, line, br);
                    }
                    this.doFirstLine(document, writer, line, "# Visual ");
                } else {
                    writer.write(line);
                    writer.write(LINE_SEP);
                }
                if (expectsPackage && line.startsWith("package ")) {
                    written = true;
                    writer.write(LINE_SEP);
                    writer.write(this.getLicenseHeader(document));
                    writer.write(LINE_SEP);
                } else if (expectsXMLDecl && line.startsWith("<?xml ")) {
                    written = true;
                    writer.write(LINE_SEP);
                    writer.write(this.getLicenseHeader(document));
                    writer.write(LINE_SEP);
                } else if (expectsPhpPI && line.startsWith("<?php")) {
                    written = true;
                    writer.write(LINE_SEP);
                    writer.write(this.getLicenseHeader(document));
                    writer.write(LINE_SEP);
                }
                first = false;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(fis);
        IOUtils.closeQuietly(writer);
        return written;
    }

    private void doFirstLine(File document, Writer writer, String line, String lookfor) throws IOException {
        if (line.startsWith(lookfor)) {
            writer.write(line);
            writer.write(LINE_SEP);
            writer.write(this.getLicenseHeader(document));
        } else {
            writer.write(this.getLicenseHeader(document));
            writer.write(line);
            writer.write(LINE_SEP);
        }
    }

    protected int getType(File document) {
        String ext;
        Integer type;
        String path = document.getPath();
        int lastDot = path.lastIndexOf(DOT);
        if (lastDot >= 0 && lastDot < path.length() - 1 && (type = EXT2TYPE.get(ext = path.substring(lastDot + 1))) != null) {
            return type;
        }
        return 0;
    }

    public void setForce(boolean force) {
        this.isForced = force;
    }

    public abstract String getLicenseHeader(File var1);

    protected String getFirstLine(int type) {
        if (AbstractLicenseAppender.isFamilyC(type)) {
            return "/*" + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilySGML(type)) {
            return "<!--" + LINE_SEP;
        }
        return "";
    }

    protected String getLastLine(int type) {
        if (AbstractLicenseAppender.isFamilyC(type)) {
            return " */" + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilySGML(type)) {
            return "-->" + LINE_SEP;
        }
        return "";
    }

    protected String getLine(int type, String content) {
        if (AbstractLicenseAppender.isFamilyC(type)) {
            return " * " + content + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilySGML(type)) {
            return content + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilyAPT(type)) {
            return "~~ " + content + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilySH(type)) {
            return "# " + content + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilyBAT(type)) {
            return "rem " + content + LINE_SEP;
        }
        if (AbstractLicenseAppender.isFamilyVelocity(type)) {
            return "## " + content + LINE_SEP;
        }
        return "";
    }

    private static boolean isFamilyC(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_C, type);
    }

    private static boolean isFamilySGML(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_SGML, type);
    }

    private static boolean isFamilySH(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_SH, type);
    }

    private static boolean isFamilyAPT(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_APT, type);
    }

    private static boolean isFamilyBAT(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_BAT, type);
    }

    private static boolean isFamilyVelocity(int type) {
        return AbstractLicenseAppender.isIn(FAMILY_VELOCITY, type);
    }

    private static boolean expectsHashPling(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_HASH_PLING, type);
    }

    private static boolean expectsAtEcho(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_AT_ECHO, type);
    }

    private static boolean expectsPackage(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_PACKAGE, type);
    }

    private static boolean expectsXMLDecl(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_XML_DECL, type);
    }

    private static boolean expectsPhpPI(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_PHP_PI, type);
    }

    private static boolean expectsMSVisualStudioSolutionFileHeader(int type) {
        return AbstractLicenseAppender.isIn(EXPECTS_MSVSSF_HEADER, type);
    }

    private static boolean isIn(int[] arr, int key) {
        return Arrays.binarySearch(arr, key) >= 0;
    }

    private String passThroughReadNext(Writer writer, String line, BufferedReader br) throws IOException {
        writer.write(line);
        writer.write(LINE_SEP);
        String l = br.readLine();
        return l == null ? "" : l;
    }

    static {
        Arrays.sort(FAMILY_C);
        Arrays.sort(FAMILY_SGML);
        Arrays.sort(FAMILY_SH);
        Arrays.sort(FAMILY_BAT);
        Arrays.sort(FAMILY_APT);
        Arrays.sort(FAMILY_VELOCITY);
        Arrays.sort(EXPECTS_HASH_PLING);
        Arrays.sort(EXPECTS_AT_ECHO);
        Arrays.sort(EXPECTS_PACKAGE);
        Arrays.sort(EXPECTS_XML_DECL);
        Arrays.sort(EXPECTS_MSVSSF_HEADER);
        EXT2TYPE.put("apt", 6);
        EXT2TYPE.put("asax", 3);
        EXT2TYPE.put("ascx", 3);
        EXT2TYPE.put("aspx", 3);
        EXT2TYPE.put("bat", 12);
        EXT2TYPE.put("bsh", 23);
        EXT2TYPE.put("c", 9);
        EXT2TYPE.put("cc", 18);
        EXT2TYPE.put("cmd", 12);
        EXT2TYPE.put("config", 2);
        EXT2TYPE.put("cpp", 18);
        EXT2TYPE.put("cs", 19);
        EXT2TYPE.put("csdproj", 2);
        EXT2TYPE.put("csproj", 2);
        EXT2TYPE.put("css", 4);
        EXT2TYPE.put("fxcop", 2);
        EXT2TYPE.put("fml", 25);
        EXT2TYPE.put("groovy", 21);
        EXT2TYPE.put("go", 26);
        EXT2TYPE.put("h", 10);
        EXT2TYPE.put("hh", 10);
        EXT2TYPE.put("hpp", 10);
        EXT2TYPE.put("htm", 3);
        EXT2TYPE.put("html", 3);
        EXT2TYPE.put("java", 1);
        EXT2TYPE.put("js", 5);
        EXT2TYPE.put("jsp", 24);
        EXT2TYPE.put("md", 28);
        EXT2TYPE.put("ndoc", 2);
        EXT2TYPE.put("nunit", 2);
        EXT2TYPE.put("php", 20);
        EXT2TYPE.put("pl", 16);
        EXT2TYPE.put("pm", 27);
        EXT2TYPE.put("properties", 7);
        EXT2TYPE.put("py", 8);
        EXT2TYPE.put("rb", 15);
        EXT2TYPE.put("rdf", 2);
        EXT2TYPE.put("resx", 2);
        EXT2TYPE.put("scala", 14);
        EXT2TYPE.put("sh", 11);
        EXT2TYPE.put("shfbproj", 2);
        EXT2TYPE.put("sln", 22);
        EXT2TYPE.put("stylecop", 2);
        EXT2TYPE.put("svg", 2);
        EXT2TYPE.put("tcl", 17);
        EXT2TYPE.put("vbdproj", 2);
        EXT2TYPE.put("vbproj", 2);
        EXT2TYPE.put("vcproj", 2);
        EXT2TYPE.put("vm", 13);
        EXT2TYPE.put("vsdisco", 2);
        EXT2TYPE.put("webinfo", 2);
        EXT2TYPE.put("xml", 2);
        EXT2TYPE.put("xproj", 2);
        EXT2TYPE.put("xsl", 2);
        EXT2TYPE.put("yaml", 29);
        EXT2TYPE.put("yml", 29);
    }
}

