/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.rat.walker.ArchiveWalker;
import org.apache.rat.walker.DirectoryWalker;

public class Report {
    private static final String ADD = "A";
    private static final String ADD_OLD = "a";
    private static final String FORCE = "f";
    private static final String COPYRIGHT = "c";
    private static final String EXCLUDE_CLI = "e";
    private static final String EXCLUDE_FILE_CLI = "E";
    private static final String STYLESHEET_CLI = "s";
    private static final String HELP = "h";
    private static final String LICENSES = "licenses";
    private static final String NO_DEFAULTS = "no-default-licenses";
    private static final String SCAN_HIDDEN_DIRECTORIES = "scan-hidden-directories";
    private static final String LIST_LICENSES = "list-licenses";
    private static final String LIST_FAMILIES = "list-families";
    private static final String LOG_LEVEL = "log-level";
    private static final String XML = "x";

    public static void main(String[] args) throws Exception {
        CommandLine cl;
        Options opts = Report.buildOptions();
        try {
            cl = new DefaultParser().parse(opts, args);
        }
        catch (ParseException e) {
            DefaultLog.INSTANCE.error(e.getMessage());
            DefaultLog.INSTANCE.error("Please use the \"--help\" option to see a list of valid commands and options");
            System.exit(1);
            return;
        }
        if (cl.hasOption(LOG_LEVEL)) {
            try {
                Log.Level level = Log.Level.valueOf(cl.getOptionValue(LOG_LEVEL).toUpperCase());
                DefaultLog.INSTANCE.setLevel(level);
            }
            catch (IllegalArgumentException e) {
                DefaultLog.INSTANCE.warn(String.format("Invalid Log Level (%s) specified.", cl.getOptionValue(LOG_LEVEL)));
                DefaultLog.INSTANCE.warn(String.format("Log level set at: %s", new Object[]{DefaultLog.INSTANCE.getLevel()}));
            }
        }
        if (cl.hasOption(HELP)) {
            Report.printUsage(opts);
        }
        if ((args = cl.getArgs()) == null || args.length != 1) {
            Report.printUsage(opts);
        } else {
            LicenseSetFactory.LicenseFilter f;
            ReportConfiguration configuration = Report.createConfiguration(args[0], cl);
            configuration.validate(DefaultLog.INSTANCE::error);
            boolean dryRun = false;
            if (cl.hasOption(LIST_FAMILIES) && (f = LicenseSetFactory.LicenseFilter.fromText(cl.getOptionValue(LIST_FAMILIES))) != LicenseSetFactory.LicenseFilter.none) {
                dryRun = true;
                Reporter.listLicenseFamilies(configuration, f);
            }
            if (cl.hasOption(LIST_LICENSES) && (f = LicenseSetFactory.LicenseFilter.fromText(cl.getOptionValue(LIST_LICENSES))) != LicenseSetFactory.LicenseFilter.none) {
                dryRun = true;
                Reporter.listLicenses(configuration, f);
            }
            if (!dryRun) {
                Reporter.report(configuration);
            }
        }
    }

    static ReportConfiguration createConfiguration(String baseDirectory, CommandLine cl) throws IOException {
        String excludeFileName;
        String[] filter;
        ReportConfiguration configuration = new ReportConfiguration(DefaultLog.INSTANCE);
        if (cl.hasOption('o')) {
            configuration.setOut(new File(cl.getOptionValue('o')));
        }
        if (cl.hasOption(SCAN_HIDDEN_DIRECTORIES)) {
            configuration.setDirectoryFilter(null);
        }
        if (cl.hasOption('a') || cl.hasOption('A')) {
            configuration.setAddLicenseHeaders(cl.hasOption('f') ? AddLicenseHeaders.FORCED : AddLicenseHeaders.TRUE);
            configuration.setCopyrightMessage(cl.getOptionValue(COPYRIGHT));
        }
        if (cl.hasOption(EXCLUDE_CLI)) {
            String[] excludes = cl.getOptionValues(EXCLUDE_CLI);
            if (excludes != null) {
                filter = Report.parseExclusions(Arrays.asList(excludes));
                configuration.setInputFileFilter((FilenameFilter)filter);
            }
        } else if (cl.hasOption(EXCLUDE_FILE_CLI) && (excludeFileName = cl.getOptionValue(EXCLUDE_FILE_CLI)) != null) {
            filter = Report.parseExclusions(FileUtils.readLines(new File(excludeFileName), StandardCharsets.UTF_8));
            configuration.setInputFileFilter((FilenameFilter)filter);
        }
        if (cl.hasOption(XML)) {
            configuration.setStyleReport(false);
        } else {
            configuration.setStyleReport(true);
            if (cl.hasOption(STYLESHEET_CLI)) {
                String[] style = cl.getOptionValues(STYLESHEET_CLI);
                if (style.length != 1) {
                    DefaultLog.INSTANCE.error("Please specify a single stylesheet");
                    System.exit(1);
                }
                configuration.setStyleSheet(() -> Files.newInputStream(Paths.get(style[0], new String[0]), new OpenOption[0]));
            }
        }
        Defaults.Builder defaultBuilder = Defaults.builder();
        if (cl.hasOption(NO_DEFAULTS)) {
            defaultBuilder.noDefault();
        }
        if (cl.hasOption(LICENSES)) {
            for (String fn : cl.getOptionValues(LICENSES)) {
                defaultBuilder.add(fn);
            }
        }
        Defaults defaults = defaultBuilder.build();
        configuration.setFrom(defaults);
        configuration.setReportable(Report.getDirectory(baseDirectory, configuration));
        return configuration;
    }

    static FilenameFilter parseExclusions(List<String> excludes) {
        OrFileFilter orFilter = new OrFileFilter();
        int ignoredLines = 0;
        for (String exclude : excludes) {
            try {
                if (exclude.startsWith("#") || StringUtils.isEmpty(exclude)) {
                    ++ignoredLines;
                    continue;
                }
                String exclusion = exclude.trim();
                orFilter.addFileFilter((IOFileFilter)new RegexFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)new NameFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)WildcardFileFilter.builder().setWildcards(exclusion).get());
            }
            catch (PatternSyntaxException e) {
                DefaultLog.INSTANCE.error("Will skip given exclusion '" + exclude + "' due to " + e);
            }
        }
        DefaultLog.INSTANCE.error("Ignored " + ignoredLines + " lines in your exclusion files as comments or empty lines.");
        return new NotFileFilter(orFilter);
    }

    static Options buildOptions() {
        String licFilterValues = String.join((CharSequence)", ", Arrays.stream(LicenseSetFactory.LicenseFilter.values()).map(Enum::name).collect(Collectors.toList()));
        Options opts = new Options().addOption(Option.builder().hasArg(true).longOpt(LIST_FAMILIES).desc("List the defined license families (default is none). Valid options are: " + licFilterValues + ".").build()).addOption(Option.builder().hasArg(true).longOpt(LIST_LICENSES).desc("List the defined licenses (default is none). Valid options are: " + licFilterValues + ".").build()).addOption(new Option(HELP, "help", false, "Print help for the RAT command line interface and exit."));
        Option out = new Option("o", "out", true, "Define the output file where to write a report to (default is System.out).");
        opts.addOption(out);
        String defaultHandlingText = " By default all approved default licenses are used";
        Option noDefaults = new Option(null, NO_DEFAULTS, false, "Ignore default configuration." + defaultHandlingText);
        opts.addOption(noDefaults);
        opts.addOption(null, LICENSES, true, "File names or URLs for license definitions");
        opts.addOption(null, SCAN_HIDDEN_DIRECTORIES, false, "Scan hidden directories");
        OptionGroup addLicenseGroup = new OptionGroup();
        String addLicenseDesc = "Add the default license header to any file with an unknown license that is not in the exclusion list. By default new files will be created with the license header, to force the modification of existing files use the --force option.";
        Option addLicence = new Option(ADD_OLD, "addLicence", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicence);
        Option addLicense = new Option(ADD, "addLicense", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicense);
        opts.addOptionGroup(addLicenseGroup);
        Option write = new Option(FORCE, "force", false, "Forces any changes in files to be written directly to the source files (i.e. new files are not created).");
        opts.addOption(write);
        Option copyright = new Option(COPYRIGHT, "copyright", true, "The copyright message to use in the license headers, usually in the form of \"Copyright 2008 Foo\"");
        opts.addOption(copyright);
        Option exclude = Option.builder(EXCLUDE_CLI).argName("expression").longOpt("exclude").hasArgs().desc("Excludes files matching wildcard <expression>. Note that --dir is required when using this parameter. Allows multiple arguments.").build();
        opts.addOption(exclude);
        Option excludeFile = Option.builder(EXCLUDE_FILE_CLI).argName("fileName").longOpt("exclude-file").hasArgs().desc("Excludes files matching regular expression in <file> Note that --dir is required when using this parameter. ").build();
        opts.addOption(excludeFile);
        Option dir = new Option("d", "dir", false, "Used to indicate source when using --exclude");
        opts.addOption(dir);
        opts.addOption(Option.builder().argName("level").longOpt(LOG_LEVEL).hasArgs().desc("sets the log level.  Valid options are: DEBUG, INFO, WARN, ERROR, OFF").build());
        OptionGroup outputType = new OptionGroup();
        Option xml = new Option(XML, "xml", false, "Output the report in raw XML format.  Not compatible with -s");
        outputType.addOption(xml);
        Option xslt = new Option(STYLESHEET_CLI, "stylesheet", true, "XSLT stylesheet to use when creating the report.  Not compatible with -x");
        outputType.addOption(xslt);
        opts.addOptionGroup(outputType);
        return opts;
    }

    private static void printUsage(Options opts) {
        HelpFormatter f = new HelpFormatter();
        f.setOptionComparator(new OptionComparator());
        String header = "\nAvailable options";
        String footer = "\nNOTE:\nRat is really little more than a grep ATM\nRat is also rather memory hungry ATM\nRat is very basic ATM\nRat highlights possible issues\nRat reports require interpretation\nRat often requires some tuning before it runs well against a project\nRat relies on heuristics: it may miss issues\n";
        f.printHelp("java -jar apache-rat/target/apache-rat-CURRENT-VERSION.jar [options] [DIR|TARBALL]", header, opts, footer, false);
        System.exit(0);
    }

    private Report() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IReportable getDirectory(String baseDirectory, ReportConfiguration config) {
        try (PrintStream out = new PrintStream(config.getOutput().get());){
            File base = new File(baseDirectory);
            if (!base.exists()) {
                config.getLog().log(Log.Level.ERROR, "Directory '" + baseDirectory + "' does not exist");
                IReportable iReportable = null;
                return iReportable;
            }
            if (base.isDirectory()) {
                DirectoryWalker directoryWalker = new DirectoryWalker(base, config.getInputFileFilter(), config.getDirectoryFilter());
                return directoryWalker;
            }
            ArchiveWalker archiveWalker = new ArchiveWalker(base, config.getInputFileFilter());
            return archiveWalker;
        }
        catch (IOException e) {
            throw new ConfigurationException("Error opening output", e);
        }
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        private String getKey(Option opt) {
            String key = opt.getOpt();
            key = key == null ? opt.getLongOpt() : key;
            return key;
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return this.getKey(opt1).compareToIgnoreCase(this.getKey(opt2));
        }
    }
}

