/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.rat.api.RatException;
import org.apache.rat.document.impl.ArchiveEntryDocument;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.walker.Walker;

public class ArchiveWalker
extends Walker
implements IReportable {
    public ArchiveWalker(File file, FilenameFilter filter) throws FileNotFoundException {
        super(file, filter);
    }

    @Override
    public void run(RatReport report) throws RatException {
        try {
            ArchiveInputStream input;
            try {
                input = new TarArchiveInputStream(new GzipCompressorInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0])));
            }
            catch (IOException e) {
                try {
                    input = new TarArchiveInputStream(new BZip2CompressorInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0])));
                }
                catch (IOException e2) {
                    input = new ZipArchiveInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
                }
            }
            Object entry = input.getNextEntry();
            while (entry != null) {
                File f = new File(entry.getName());
                byte[] contents = new byte[(int)entry.getSize()];
                int offset = 0;
                int length = contents.length;
                while ((long)offset < entry.getSize()) {
                    int actualRead = input.read(contents, offset, length);
                    length -= actualRead;
                    offset += actualRead;
                }
                if (!entry.isDirectory() && this.isNotIgnored(f)) {
                    this.report(report, contents, f);
                }
                entry = input.getNextEntry();
            }
            input.close();
        }
        catch (IOException e) {
            throw new RatException(e);
        }
    }

    private void report(RatReport report, byte[] contents, File file) throws RatException {
        ArchiveEntryDocument document = new ArchiveEntryDocument(file, contents);
        report.report(document);
    }
}

