/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class LambdaTest
extends JexlTestCase {
    public LambdaTest() {
        super("LambdaTest");
    }

    @Test
    public void testScriptArguments() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript(" x + x ", new String[]{"x"});
        JexlScript s42 = jexl.createScript("s(21)", new String[]{"s"});
        Object result = s42.execute(null, new Object[]{s});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testScriptContext() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript("function(x) { x + x }");
        String fsstr = s.getParsedText(0);
        Assert.assertEquals((Object)"(x)->{ x + x; }", (Object)fsstr);
        Assert.assertEquals((Object)42, (Object)s.execute(null, new Object[]{21}));
        JexlScript s42 = jexl.createScript("s(21)");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", s);
        Object result = s42.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        result = s42.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        s42 = jexl.createScript("x-> { x + x }");
        result = s42.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambda() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var s = function(x) { x + x }; s(21)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var s = function(x, y) { x + y }; s(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaClosure() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 20; var s = function(x, y) { x + y + t}; s(15, 7)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 20; var s = function(x, y) {x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaLambda() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 19; ( (x, y)->{ var t = 20; x + y + t} )(15, 7);";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "( (x, y)->{ ( (xx, yy)->{xx + yy } )(x, y) } )(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = (x, y)->{ var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNestLambda() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "( (x)->{ (y)->{ x + y } })(15)(27)";
        JexlScript s42 = jexl.createScript("( (x)->{ (y)->{ x + y } })(15)(27)");
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNestLambada() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlContext ctx = null;
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript("(x)->{ (y)->{ x + y } }");
        JexlScript s42b = jexl.createScript(s42.toString());
        Assert.assertEquals((long)s42.hashCode(), (long)s42b.hashCode());
        Assert.assertEquals((Object)s42, (Object)s42b);
        Object result = s42.execute(ctx, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        Object resultb = s42.execute(ctx, new Object[]{15});
        Assert.assertEquals((long)result.hashCode(), (long)resultb.hashCode());
        Assert.assertEquals((Object)result, (Object)resultb);
        Assert.assertEquals((Object)result, (Object)jexl.createScript(resultb.toString(), new String[]{"x"}).execute(ctx, new Object[]{15}));
        JexlScript s15 = (JexlScript)result;
        Callable s15b = s15.callable(ctx, new Object[]{27});
        result = s15.execute(ctx, new Object[]{27});
        Assert.assertEquals((Object)42, (Object)result);
        result = s15b.call();
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testHoistLambda() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlEvalContext ctx = new JexlEvalContext();
        ctx.getEngineOptions().setLexical(false);
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        JexlScript s15 = (JexlScript)result;
        String[] localv = s15.getLocalVariables();
        Assert.assertEquals((long)0L, (long)localv.length);
        Set hvars = s15.getVariables();
        Assert.assertEquals((long)1L, (long)hvars.size());
        strs = "(x)->{ (y)->{ var z = 169; var x; x + y } }";
        s42 = jexl.createScript(strs);
        result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        s15 = (JexlScript)result;
        localv = s15.getLocalVariables();
        Assert.assertNotNull((Object)localv);
        Assert.assertEquals((long)1L, (long)localv.length);
        hvars = s15.getVariables();
        Assert.assertEquals((long)1L, (long)hvars.size());
        result = s15.execute((JexlContext)ctx, new Object[]{27});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testRecurse() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        try {
            JexlScript script = jexl.createScript("var fact = (x)->{ if (x <= 1) 1; else x * fact(x - 1) }; fact(5)");
            int result = (Integer)script.execute((JexlContext)jc);
            Assert.assertEquals((long)120L, (long)result);
        }
        catch (JexlException xany) {
            String msg = xany.toString();
            throw xany;
        }
    }

    @Test
    public void testRecurse2() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        try {
            JexlScript script = jexl.createScript("var y = 1; var z = 1; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
            int result = (Integer)script.execute((JexlContext)jc);
            Assert.assertEquals((long)720L, (long)result);
        }
        catch (JexlException xany) {
            String msg = xany.toString();
            throw xany;
        }
    }

    @Test
    public void testRecurse3() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        try {
            JexlScript script = jexl.createScript("var y = 1; var z = 1;var foo = (x)->{y + z}; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
            int result = (Integer)script.execute((JexlContext)jc);
            Assert.assertEquals((long)720L, (long)result);
        }
        catch (JexlException xany) {
            String msg = xany.toString();
            throw xany;
        }
    }

    @Test
    public void testIdentity() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(x)->{ x }");
        Assert.assertArrayEquals((Object[])new String[]{"x"}, (Object[])script.getParameters());
        Object result = script.execute(null, new Object[]{42});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry1() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String[] parms = base.getUnboundParameters();
        Assert.assertEquals((long)3L, (long)parms.length);
        JexlScript script = base.curry(new Object[]{5});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)2L, (long)parms.length);
        script = script.curry(new Object[]{15});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)1L, (long)parms.length);
        script = script.curry(new Object[]{22});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)0L, (long)parms.length);
        Object result = script.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry2() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        String[] parms = script.getUnboundParameters();
        Assert.assertEquals((long)1L, (long)parms.length);
        script = script.curry(new Object[]{22});
        Object result = script.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry3() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        Object result = script.execute(null, new Object[]{22});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test270() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String text = base.toString();
        JexlScript script = base.curry(new Object[]{5, 15});
        Assert.assertEquals((Object)text, (Object)script.toString());
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", base);
        script = jexl.createScript("return s");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)text, (Object)result.toString());
        script = jexl.createScript("return s.curry(1)");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)text, (Object)result.toString());
    }

    @Test
    public void test271a() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 1; var x = (a)->{ var y = (b) -> {base + b}; return base + y(a)}; x(40)");
        Object result = base.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test271b() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; var sum = (x, y, z)->{ base + x + y + z }; var y = sum.curry(1); y(2,3)");
        Object result = base.execute(null);
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271c() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ 2 + x + y + z };");
        JexlScript y = base.curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271d() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; return (x, y, z)->{ base + x + y + z };");
        JexlScript y = ((JexlScript)base.execute(null)).curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assert.assertEquals((Object)8, (Object)result);
    }
}

