/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.sensor.SensorPredicates;
import org.apache.brooklyn.util.core.task.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Propagator", description="Propagates sensors from one entity to another")
public class Propagator
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Propagator.class);
    public static final Set<Sensor<?>> SENSORS_NOT_USUALLY_PROPAGATED = ImmutableSet.of(Attributes.SERVICE_UP, Attributes.SERVICE_NOT_UP_INDICATORS, Attributes.SERVICE_STATE_ACTUAL, Attributes.SERVICE_STATE_EXPECTED, Attributes.SERVICE_PROBLEMS);
    @SetFromFlag(value="producer")
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer");
    @SetFromFlag(value="propagatingAllBut")
    public static final ConfigKey<Collection<? extends Sensor<?>>> PROPAGATING_ALL_BUT = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends Sensor<?>>>(){}, "enricher.propagating.propagatingAllBut");
    @SetFromFlag(value="propagatingAll")
    public static final ConfigKey<Boolean> PROPAGATING_ALL = ConfigKeys.newBooleanConfigKey("enricher.propagating.propagatingAll");
    @SetFromFlag(value="propagating")
    public static final ConfigKey<Collection<? extends Sensor<?>>> PROPAGATING = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends Sensor<?>>>(){}, "enricher.propagating.inclusions");
    @SetFromFlag(value="sensorMapping")
    public static final ConfigKey<Map<? extends Sensor<?>, ? extends Sensor<?>>> SENSOR_MAPPING = ConfigKeys.newConfigKey(new TypeToken<Map<? extends Sensor<?>, ? extends Sensor<?>>>(){}, "enricher.propagating.sensorMapping");
    protected Entity producer;
    protected Map<Sensor<?>, Sensor<?>> sensorMapping;
    protected boolean propagatingAll;
    protected Collection<Sensor<?>> propagatingAllBut;
    protected Predicate<? super Sensor<?>> sensorFilter;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER);
        this.sensorMapping = this.resolveSensorMappings(this.getConfig(SENSOR_MAPPING));
        this.propagatingAllBut = this.resolveSensorCollection((Iterable)this.getConfig(PROPAGATING_ALL_BUT));
        this.propagatingAll = Boolean.TRUE.equals(this.getConfig(PROPAGATING_ALL)) || this.propagatingAllBut.size() > 0;
        List<Sensor<?>> propagating = this.resolveSensorCollection((Iterable)this.getConfig(PROPAGATING));
        if (this.producer == null) {
            LOG.debug("Defaulting to producer==self for {}, on entity {}", (Object)this, (Object)entity);
            this.producer = entity;
        }
        if (propagating.isEmpty() && this.sensorMapping.isEmpty() && !this.propagatingAll) {
            throw new IllegalStateException("Propagator enricher " + this + " must have 'propagating' and/or 'sensorMapping', or 'propagatingAll' or 'propagatingAllBut' set");
        }
        if (entity.equals(this.producer)) {
            if (this.propagatingAll) {
                throw new IllegalStateException("Propagator enricher " + this + " must not have " + PROPAGATING_ALL.getName() + " or " + PROPAGATING_ALL_BUT.getName() + ", when publishing to own entity (to avoid infinite loop)");
            }
            if (propagating.size() > 0) {
                throw new IllegalStateException("Propagator enricher " + this + " must not have " + PROPAGATING.getName() + ", when publishing to own entity (to avoid infinite loop)");
            }
            if (this.filterForKeyEqualsValue(this.sensorMapping).size() > 0) {
                Map<Sensor<?>, Sensor<?>> selfPublishingSensors = this.filterForKeyEqualsValue(this.sensorMapping);
                throw new IllegalStateException("Propagator enricher " + this + " must not publish to same sensor in config " + SENSOR_MAPPING.getName() + " (" + selfPublishingSensors.keySet() + "), when publishing to own entity (to avoid infinite loop)");
            }
        }
        if ((propagating.size() > 0 || this.sensorMapping.size() > 0) && this.propagatingAll) {
            throw new IllegalStateException("Propagator enricher " + this + " must not have 'propagating' or 'sensorMapping' set at same time as either 'propagatingAll' or 'propagatingAllBut'");
        }
        if (propagating.size() > 0) {
            for (Sensor sensor : propagating) {
                if (this.sensorMapping.containsKey(sensor)) continue;
                this.sensorMapping.put(sensor, sensor);
            }
            this.sensorMapping = ImmutableMap.copyOf(this.sensorMapping);
            this.sensorFilter = Predicates.alwaysTrue();
            new Predicate<Sensor<?>>(){

                public boolean apply(Sensor<?> input) {
                    return true;
                }
            };
        } else if (this.sensorMapping.size() > 0) {
            this.sensorMapping = ImmutableMap.copyOf(this.sensorMapping);
            this.sensorFilter = Predicates.alwaysTrue();
        } else {
            Preconditions.checkState((boolean)this.propagatingAll, (String)"Impossible case: propagatingAll=%s; propagating=%s; sensorMapping=%s", (Object)this.propagatingAll, propagating, this.sensorMapping);
            this.sensorMapping = ImmutableMap.of();
            this.sensorFilter = new Predicate<Sensor<?>>(){

                public boolean apply(Sensor<?> input) {
                    return input != null && !Propagator.this.propagatingAllBut.contains(input);
                }
            };
        }
        Preconditions.checkState((boolean)(this.propagatingAll ^ this.sensorMapping.size() > 0), (String)"Nothing to propagate; detected: propagatingAll (%s, excluding %s), sensorMapping (%s)", (Object)this.propagatingAll, this.getConfig(PROPAGATING_ALL_BUT), this.sensorMapping);
        if (this.propagatingAll) {
            this.subscriptions().subscribe(this.producer, null, this);
            this.highlightTriggers("Listening for all sensors on " + this.producer);
        } else {
            for (Sensor sensor : this.sensorMapping.keySet()) {
                this.subscriptions().subscribe(this.producer, sensor, this);
            }
            if (this.sensorMapping.keySet().size() > 3) {
                this.highlightTriggers("Listening for " + this.sensorMapping.keySet() + " sensors on " + this.producer);
            } else {
                this.highlightTriggers(this.sensorMapping.keySet(), (Object)this.producer);
            }
        }
        this.emitAllAttributes();
    }

    public void onEvent(SensorEvent<Object> event) {
        Sensor sourceSensor = event.getSensor();
        Sensor<?> destinationSensor = this.getDestinationSensor(sourceSensor);
        if (!this.sensorFilter.apply((Object)sourceSensor)) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("enricher {} got {}, propagating via {}{}", new Object[]{this, event, this.entity, sourceSensor == destinationSensor ? "" : " (as " + destinationSensor + ")"});
        }
        this.emit(destinationSensor, event.getValue());
    }

    public void emitAllAttributes() {
        this.emitAllAttributes(false);
    }

    public void emitAllAttributes(boolean includeNullValues) {
        Set<Sensor<?>> sensorsToPopulate = this.propagatingAll ? Iterables.filter((Iterable)this.producer.getEntityType().getSensors(), this.sensorFilter) : this.sensorMapping.keySet();
        for (Sensor sensor : sensorsToPopulate) {
            if (!(sensor instanceof AttributeSensor)) continue;
            AttributeSensor destinationSensor = (AttributeSensor)this.getDestinationSensor(sensor);
            Object v = this.producer.getAttribute((AttributeSensor)sensor);
            if (v == null && !includeNullValues) continue;
            this.entity.sensors().set(destinationSensor, v);
        }
    }

    private Sensor<?> getDestinationSensor(Sensor<?> sourceSensor) {
        Optional mappingSensor = Iterables.tryFind(this.sensorMapping.keySet(), SensorPredicates.nameEqualTo(sourceSensor.getName()));
        return mappingSensor.isPresent() ? this.sensorMapping.get(mappingSensor.get()) : sourceSensor;
    }

    private Map<Sensor<?>, Sensor<?>> resolveSensorMappings(Map<?, ?> mapping) {
        if (mapping == null) {
            return MutableMap.of();
        }
        MutableMap result = MutableMap.of();
        for (Map.Entry<?, ?> entry : mapping.entrySet()) {
            Object keyO = entry.getKey();
            Object valueO = entry.getValue();
            Sensor key = Tasks.resolving(keyO).as(Sensor.class).immediately(true).context(this.producer).get();
            Sensor value = Tasks.resolving(valueO).as(Sensor.class).immediately(true).context(this.producer).get();
            result.put(key, value);
        }
        return result;
    }

    private List<Sensor<?>> resolveSensorCollection(Iterable<?> sensors) {
        if (sensors == null) {
            return MutableList.of();
        }
        MutableList result = MutableList.of();
        for (Object sensorO : sensors) {
            Sensor sensor = Tasks.resolving(sensorO).as(Sensor.class).immediately(true).context(this.producer).get();
            result.add(sensor);
        }
        return result;
    }

    private <K, V> Map<K, V> filterForKeyEqualsValue(Map<K, V> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!Objects.equal(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

