/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.store.WorkflowStateActiveInMemory;
import org.apache.brooklyn.core.workflow.store.WorkflowStatePersistenceViaSensors;
import org.apache.brooklyn.core.workflow.utils.WorkflowRetentionParser;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRetentionAndExpiration {
    private static final Logger log = LoggerFactory.getLogger(WorkflowRetentionAndExpiration.class);
    public static final ConfigKey<String> WORKFLOW_RETENTION_DEFAULT = ConfigKeys.newStringConfigKey("workflow.retention.default", "Default retention for workflows", "3");
    static ThreadLocal<Set<String>> INIT_REENTRANT = new ThreadLocal();

    static Map<String, WorkflowExecutionContext> recomputeExpiration(Map<String, WorkflowExecutionContext> v, WorkflowExecutionContext optionalContext) {
        MutableSet workflowHashesToUpdate = optionalContext != null ? MutableSet.of((Object)Strings.firstNonBlank((CharSequence[])new String[]{optionalContext.getRetentionHash(), "empty-expiry-hash"})) : v.values().stream().map(WorkflowExecutionContext::getRetentionHash).collect(Collectors.toSet());
        workflowHashesToUpdate.forEach(k -> {
            WorkflowRetentionParser.WorkflowRetentionFilter expiry;
            List finishedTwins = v.values().stream().filter(c -> k.equals(c.getRetentionHash())).filter(c -> WorkflowRetentionAndExpiration.isExpirable(c)).filter(c -> !c.equals(optionalContext)).collect(Collectors.toList());
            if (finishedTwins.isEmpty()) {
                return;
            }
            Optional<WorkflowExecutionContext> existingRetentionExpiry = finishedTwins.stream().filter(w -> w.getRetentionSettings().expiry != null).findAny();
            if (existingRetentionExpiry.isPresent()) {
                if (optionalContext != null && optionalContext.getRetentionHash().equals(k) && optionalContext.getRetentionSettings().expiry != null && !optionalContext.getRetentionSettings().expiry.equals(existingRetentionExpiry.get().getRetentionSettings().expiry)) {
                    log.warn("Retention specification for " + optionalContext + " '" + optionalContext.getRetentionSettings().expiry + "' is different for same hash. Expiry should be constant within a hash but " + existingRetentionExpiry.get() + " has '" + existingRetentionExpiry.get().getRetentionSettings().expiry + "'");
                }
                expiry = existingRetentionExpiry.get().getRetentionSettings().getExpiryFn(existingRetentionExpiry.get());
            } else {
                expiry = WorkflowRetentionParser.newDefaultFilter().init((WorkflowExecutionContext)finishedTwins.iterator().next());
            }
            Collection retainedFinishedTwins = (Collection)expiry.apply(finishedTwins);
            if (retainedFinishedTwins.size() < finishedTwins.size()) {
                MutableSet toRemove = MutableSet.copyOf(finishedTwins);
                toRemove.removeAll(retainedFinishedTwins);
                toRemove.forEach(w -> {
                    log.debug("Expiring old workflow " + w + " as there are " + retainedFinishedTwins.size() + " more recent ones also completed");
                    WorkflowRetentionAndExpiration.deleteWorkflowFromMap(v, w, true);
                });
            }
        });
        return v;
    }

    static boolean deleteWorkflowFromMap(Map<String, WorkflowExecutionContext> v, WorkflowExecutionContext w, boolean andAllReplayTasks) {
        boolean removed = v.remove(w.getWorkflowId()) != null;
        removed |= WorkflowStateActiveInMemory.get(w.getManagementContext()).deleteWorkflow(w);
        if (andAllReplayTasks) {
            BasicExecutionManager em = (BasicExecutionManager)w.getManagementContext().getExecutionManager();
            w.getReplays().forEach(wr -> {
                Task<?> wrt = em.getTask(wr.getTaskId());
                if (wrt != null) {
                    em.deleteTask(wrt, false, true);
                }
            });
        }
        return removed;
    }

    private static boolean isExpirable(WorkflowExecutionContext c) {
        if (c.getStatus() == null || !c.getStatus().expirable) {
            return false;
        }
        return c.getParent() == null || WorkflowRetentionAndExpiration.isExpirable(c.getParent());
    }

    static boolean isExpirationCheckNeeded(Entity entity) {
        if (Tasks.isAncestor(Tasks.current(), t -> BrooklynTaskTags.getTagsFast(t).contains(BrooklynTaskTags.ENTITY_INITIALIZATION))) {
            return false;
        }
        return !Entities.isUnmanagingOrNoLongerManaged(entity);
    }

    public static void expireOldWorkflows(Entity entity) {
        new WorkflowStatePersistenceViaSensors(((EntityInternal)entity).getManagementContext()).updateMap(entity, true, true, null);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class WorkflowRetentionSettings {
        public Boolean disabled;
        public String hash;
        public String expiry;
        public String expiryResolved;
        @JsonIgnore
        private transient WorkflowRetentionParser.WorkflowRetentionFilter expiryFn;

        public WorkflowRetentionParser.WorkflowRetentionFilter getExpiryFn(WorkflowExecutionContext w) {
            return this.init((WorkflowExecutionContext)w).expiryFn;
        }

        public WorkflowRetentionSettings init(WorkflowExecutionContext w) {
            if (w.getParent() != null && Boolean.TRUE.equals(w.getParent().getRetentionSettings().disabled)) {
                this.disabled = true;
            } else if (this.expiryFn == null) {
                this.expiryResolved = this.expiryResolved != null ? this.expiryResolved : this.expiry;
                this.expiryFn = new WorkflowRetentionParser(this.expiryResolved).parse();
                if (w != null) {
                    MutableSet set = INIT_REENTRANT.get();
                    if (set == null) {
                        set = MutableSet.of();
                        INIT_REENTRANT.set((Set<String>)set);
                    }
                    if (!set.add(w.getWorkflowId() + ":" + this.expiryResolved)) {
                        throw new IllegalStateException("Invalid workflow retention '" + this.expiryResolved + "' as it refers to itself");
                    }
                    try {
                        this.expiryFn = this.expiryFn.init(w);
                    }
                    finally {
                        set.remove(w.getWorkflowId() + ":" + this.expiryResolved);
                        if (set.isEmpty()) {
                            INIT_REENTRANT.remove();
                        }
                    }
                }
                this.expiryResolved = this.expiryFn.toString();
            }
            return this;
        }

        public void updateFrom(WorkflowRetentionSettings r2) {
            if (Strings.isNonBlank((CharSequence)r2.hash)) {
                this.hash = r2.hash;
            }
            Boolean bl = this.disabled = Boolean.TRUE.equals(r2.disabled) ? Boolean.valueOf(true) : null;
            if (Strings.isNonEmpty((CharSequence)r2.expiry)) {
                this.expiry = r2.expiry;
                this.expiryFn = r2.expiryFn;
                this.expiryResolved = r2.expiryResolved;
            }
        }
    }
}

