/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.javalang.BrooklynHttpConfig;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.http.auth.UsernamePassword;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.HttpRequest;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger log = LoggerFactory.getLogger(HttpWorkflowStep.class);
    public static final String SHORTHAND = "${endpoint}";
    public static final ConfigKey<String> ENDPOINT = ConfigKeys.newStringConfigKey("endpoint");
    public static final ConfigKey<Map<String, Object>> QUERY = new MapConfigKey.Builder<Object>(Object.class, "query").build();
    public static final ConfigKey<Object> BODY = ConfigKeys.newConfigKey(Object.class, "body");
    public static final ConfigKey<String> CHARSET = ConfigKeys.newStringConfigKey("charset", "Character set to interpret content as when converting to string, and for converting body to bytes to upload if body is set");
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> STATUS_CODE = ConfigKeys.newConfigKey(new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, "status_code");
    public static final ConfigKey<Map<String, String>> HEADERS = new MapConfigKey<String>(String.class, "headers");
    public static final ConfigKey<String> METHOD = ConfigKeys.newStringConfigKey("method");
    public static final ConfigKey<HttpConfig> HTTPS_CONFIG = ConfigKeys.newConfigKey(HttpConfig.class, "config");
    public static final ConfigKey<String> USERNAME = ConfigKeys.newStringConfigKey("username", "Username for HTTP request, if required");
    public static final ConfigKey<String> PASSWORD = ConfigKeys.newStringConfigKey("password", "Password for HTTP request, if required");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        HttpResponse response;
        Map<String, String> headers;
        String endpoint = context.getInput(ENDPOINT);
        if (Strings.isBlank((CharSequence)endpoint)) {
            throw new IllegalStateException("Endpoint required for http step");
        }
        String proto = Urls.getProtocol((String)endpoint);
        if (proto == null) {
            endpoint = "https://" + endpoint;
        }
        HttpRequest.Builder httpb = new HttpRequest.Builder();
        try {
            URIBuilder urib = new URIBuilder(endpoint);
            Map<String, Object> params = context.getInput(QUERY);
            if (params != null) {
                new ShellEnvironmentSerializer(context.getManagementContext()).serialize(params).forEach((k, v) -> urib.addParameter(k, v));
            }
            httpb.uri(urib.build());
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagateAnnotated((String)("Invalid URI: " + endpoint), (Throwable)e);
        }
        String username = context.getInput(USERNAME);
        String password = context.getInput(PASSWORD);
        if (Strings.isNonBlank((CharSequence)username) || Strings.isNonBlank((CharSequence)password)) {
            if (Strings.isNonBlank((CharSequence)username) && Strings.isNonBlank((CharSequence)password)) {
                httpb.credentials((Credentials)new UsernamePassword(username, password));
            } else {
                throw new IllegalStateException("Must supply either both 'username' and 'password' or neither");
            }
        }
        if ((headers = context.getInput(HEADERS)) != null) {
            httpb.headers(headers);
        }
        httpb.config(context.getInput(HTTPS_CONFIG));
        String method = context.getInput(METHOD);
        if (Strings.isBlank((CharSequence)method)) {
            method = "get";
        }
        httpb.method(method);
        String charsetS = context.getInput(CHARSET);
        Charset charset = Strings.isBlank((CharSequence)charsetS) ? Charset.defaultCharset() : Charset.forName(charsetS);
        Object body = context.getInput(BODY);
        if (body != null) {
            if (body instanceof byte[]) {
                httpb.body((byte[])body);
            } else {
                try {
                    String bodyS = BeanWithTypeUtils.newMapper(context.getManagementContext(), false, null, false).writeValueAsString(body);
                    httpb.body(bodyS.getBytes(charset));
                }
                catch (JsonProcessingException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        long startTime = System.currentTimeMillis();
        HttpExecutor httpExecutor = BrooklynHttpConfig.newHttpExecutor((BrooklynObject)context.getEntity());
        try {
            response = httpExecutor.execute(httpb.build());
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        byte[] contentBytes = Streams.readFully((InputStream)response.getContent());
        long endTime = System.currentTimeMillis();
        String contentString = new String(contentBytes, charset);
        Predicate<Integer> exitcode = (Predicate<Integer>)((Object)context.getInput(STATUS_CODE));
        if (exitcode == null) {
            exitcode = code -> HttpTool.isStatusCodeHealthy((int)code);
        }
        Object content_json = null;
        try {
            content_json = BeanWithTypeUtils.newSimpleMapper().readValue(contentString, Object.class);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.debug("Content from web request is not json; not setting content_json: " + e);
        }
        context.setOutput(MutableMap.of((Object)"status_code", (Object)response.code(), (Object)"headers", (Object)response.headers(), (Object)"content", (Object)contentString, (Object)"content_bytes", (Object)contentBytes, (Object)"content_json", (Object)content_json, (Object)"duration", (Object)Duration.millis((Number)(endTime - startTime))));
        this.checkExitCode(response.code(), exitcode);
        return context.getOutput();
    }

    protected void checkExitCode(Integer code, Predicate<Integer> exitcode) {
        Object implicit;
        if (exitcode == null) {
            return;
        }
        if (exitcode instanceof DslPredicates.DslPredicateBase && (implicit = ((DslPredicates.DslPredicateBase)((Object)exitcode)).implicitEqualsUnwrapped()) != null && "any".equalsIgnoreCase("" + implicit)) {
            return;
        }
        if (!exitcode.test(code)) {
            throw new IllegalStateException("Invalid response status code '" + code + "'");
        }
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return false;
    }
}

