/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.appmodel.EntityValueToSet;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSensorWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(SetSensorWorkflowStep.class);
    public static final String SHORTHAND = "[ ${sensor.type} ] ${sensor.name} [ \"=\" ${value...} ]";
    public static final ConfigKey<EntityValueToSet> SENSOR = ConfigKeys.newConfigKey(EntityValueToSet.class, "sensor");
    public static final ConfigKey<Object> VALUE = ConfigKeys.newConfigKey(Object.class, "value");
    public static final ConfigKey<DslPredicates.DslPredicate> REQUIRE = ConfigKeys.newConfigKey(DslPredicates.DslPredicate.class, "require");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Object oldValue;
        EntityValueToSet sensor = context.getInput(SENSOR);
        if (sensor == null) {
            throw new IllegalArgumentException("Sensor name is required");
        }
        String sensorNameFull = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)sensor.name, String.class);
        if (Strings.isBlank((CharSequence)sensorNameFull)) {
            throw new IllegalArgumentException("Sensor name is required");
        }
        MutableList sensorNameIndexes = MutableList.of();
        String sensorNameBase = SetSensorWorkflowStep.extractSensorNameBaseAndPopulateIndices(sensorNameFull, (List<Object>)sensorNameIndexes);
        TypeToken<?> type = context.lookupType(sensor.type, () -> TypeToken.of(Object.class));
        Entity entity = sensor.entity != null ? sensor.entity : context.getEntity();
        AttributeSensor<?> sensorBase = Sensors.newSensor(type, sensorNameBase);
        AtomicReference resolvedValue = new AtomicReference();
        Runnable resolve = () -> resolvedValue.set(context.getInput(VALUE.getName(), type));
        DslPredicates.DslPredicate require = context.getInput(REQUIRE);
        if (require == null && sensorNameIndexes.isEmpty()) {
            resolve.run();
            oldValue = entity.sensors().set(sensorBase, resolvedValue.get());
        } else {
            oldValue = entity.sensors().modify(sensorBase, arg_0 -> SetSensorWorkflowStep.lambda$doTaskBody$2(require, (List)sensorNameIndexes, entity, sensorBase, sensorNameFull, resolve, resolvedValue, arg_0));
        }
        context.noteOtherMetadata("Value set", resolvedValue.get());
        if (oldValue != null) {
            context.noteOtherMetadata("Previous value", oldValue);
        }
        return context.getPreviousStepOutput();
    }

    static String extractSensorNameBaseAndPopulateIndices(String sensorNameFull, List<Object> sensorNameIndexes) {
        String sensorNameBase;
        int bracket = sensorNameFull.indexOf(91);
        if (bracket > 0) {
            sensorNameBase = sensorNameFull.substring(0, bracket);
            String brackets = sensorNameFull.substring(bracket);
            while (!brackets.isEmpty()) {
                if (!brackets.startsWith("[")) {
                    throw new IllegalArgumentException("Expected '[' for sensor index");
                }
                int bi = (brackets = brackets.substring(1).trim()).indexOf(93);
                if (bi < 0) {
                    throw new IllegalArgumentException("Mismatched ']' in sensor name");
                }
                String bs = brackets.substring(0, bi).trim();
                if (bs.startsWith("\"") || bs.startsWith("'")) {
                    bs = StringEscapes.BashStringEscapes.unwrapBashQuotesAndEscapes((String)bs);
                } else if (bs.matches("-? *[0-9]+")) {
                    sensorNameIndexes.add(Integer.parseInt(bs));
                    bs = null;
                }
                if (bs != null) {
                    sensorNameIndexes.add(bs);
                }
                brackets = brackets.substring(bi + 1).trim();
            }
        } else {
            if (bracket == 0) {
                throw new IllegalArgumentException("Sensor name cannot start with '['");
            }
            sensorNameBase = sensorNameFull;
        }
        return sensorNameBase;
    }

    static Object makeMutable(Object x, List<Object> indexesRemaining) {
        if (x == null) {
            if (indexesRemaining != null && !indexesRemaining.isEmpty() && indexesRemaining.get(0) instanceof Integer) {
                return MutableList.of();
            }
            return MutableMap.of();
        }
        if (x instanceof Set) {
            if (!(x instanceof MutableSet)) {
                return MutableSet.copyOf((Iterable)((Set)x));
            }
            return x;
        }
        if (x instanceof Map && !(x instanceof MutableMap)) {
            return MutableMap.copyOf((Map)((Map)x));
        }
        if (x instanceof Iterable && !(x instanceof MutableList)) {
            return MutableList.copyOf((Iterable)((Iterable)x));
        }
        return x;
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    private static /* synthetic */ Maybe lambda$doTaskBody$2(DslPredicates.DslPredicate require, List sensorNameIndexes, Entity entity, AttributeSensor sensorBase, String sensorNameFull, Runnable resolve, AtomicReference resolvedValue, Object oldBase) {
        Object result;
        if (require != null) {
            Object old = oldBase;
            MutableList indexes = MutableList.copyOf((Iterable)sensorNameIndexes);
            while (!indexes.isEmpty()) {
                Object i = indexes.remove(0);
                if (old == null) break;
                if (old instanceof Map) {
                    old = ((Map)old).get(i);
                    continue;
                }
                if (old instanceof Iterable && i instanceof Integer) {
                    int ii = (Integer)i;
                    int size = Iterables.size((Iterable)((Iterable)old));
                    if (ii == -1) {
                        ii = size - 1;
                    }
                    old = ii < 0 || ii >= size ? null : Iterables.get((Iterable)((Iterable)old), (int)ii);
                    continue;
                }
                throw new IllegalArgumentException("Cannot find argument '" + i + "' in " + old);
            }
            if (old == null && !((AbstractEntity.BasicSensorSupport)entity.sensors()).contains(sensorBase.getName())) {
                DslPredicates.DslEntityPredicateDefault requireTweaked = new DslPredicates.DslEntityPredicateDefault();
                requireTweaked.sensor = sensorNameFull;
                requireTweaked.check = WrappedValue.of(require);
                if (!requireTweaked.apply(entity)) {
                    throw new SensorRequirementFailedAbsent("Sensor " + sensorNameFull + " unset or unavailable when there is a non-absent requirement");
                }
            } else if (!require.apply(old)) {
                throw new SensorRequirementFailed("Sensor " + sensorNameFull + " value does not match requirement", old);
            }
        }
        resolve.run();
        if (!sensorNameIndexes.isEmpty()) {
            result = oldBase;
            Object target = result = SetSensorWorkflowStep.makeMutable(result, sensorNameIndexes);
            MutableList indexes = MutableList.copyOf((Iterable)sensorNameIndexes);
            while (!indexes.isEmpty()) {
                Object nextTarget;
                Object i = indexes.remove(0);
                boolean isLast = indexes.isEmpty();
                if (target instanceof Map) {
                    nextTarget = ((Map)target).get(i);
                    if (nextTarget == null || isLast || !(nextTarget instanceof MutableMap)) {
                        nextTarget = isLast ? resolvedValue.get() : SetSensorWorkflowStep.makeMutable(nextTarget, (List<Object>)indexes);
                        ((Map)target).put(i, nextTarget);
                    }
                } else if (target instanceof Iterable && i instanceof Integer) {
                    int ii = (Integer)i;
                    int size = Iterables.size((Iterable)((Iterable)target));
                    if (ii == -1) {
                        ii = size - 1;
                    }
                    boolean outOfBounds = ii < 0 || ii >= size;
                    Object v = nextTarget = outOfBounds ? null : Iterables.get((Iterable)((Iterable)target), (int)ii);
                    if (nextTarget == null || isLast || !(nextTarget instanceof MutableMap) && !(nextTarget instanceof MutableSet) && !(nextTarget instanceof MutableList)) {
                        Object object = nextTarget = isLast ? resolvedValue.get() : SetSensorWorkflowStep.makeMutable(nextTarget, (List<Object>)indexes);
                        if (outOfBounds) {
                            ((Collection)target).add(nextTarget);
                        } else {
                            if (!(target instanceof List)) {
                                throw new IllegalStateException("Cannot set numerical position index in a non-list collection (and was not otherwise known as mutable; e.g. use MutableSet): " + target);
                            }
                            ((List)target).set(ii, nextTarget);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Cannot find argument '" + i + "' in " + target);
                }
                target = nextTarget;
            }
        } else {
            result = resolvedValue.get();
        }
        return Maybe.of((Object)result);
    }

    public static class SensorRequirementFailedAbsent
    extends SensorRequirementFailed {
        public SensorRequirementFailedAbsent(String message) {
            super(message, (Object)null);
        }
    }

    public static class SensorRequirementFailed
    extends RuntimeException {
        private final Object sensorValue;

        public SensorRequirementFailed(String message, Object value) {
            super(message);
            this.sensorValue = value;
        }

        public Object getSensorValue() {
            return this.sensorValue;
        }
    }
}

