/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.reflect.TypeToken;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.LossySerializingThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkflowStepInstanceExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStepInstanceExecutionContext.class);
    static final boolean REMEMBER_RESOLVED_INPUT = true;
    int stepIndex;
    String stepDefinitionDeclaredId;
    String name;
    String taskId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Map<String, Object> input = MutableMap.of();
    @JsonIgnore
    Map<String, Object> inputResolved = MutableMap.of();
    transient WorkflowExecutionContext context;
    public Object next;
    transient Throwable error;
    @XStreamAlias(value="error")
    @JsonIgnore
    Throwable errorLegacyDeserialized;
    @JsonIgnore
    LossySerializingThrowable errorRecord;
    String errorHandlerTaskId;
    Object stepState;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Set<BrooklynTaskTags.WorkflowTaskTag> subWorkflows = MutableSet.of();
    transient Object outputOld;
    Object output;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> otherMetadata = MutableMap.of();

    private WorkflowStepInstanceExecutionContext() {
    }

    public WorkflowStepInstanceExecutionContext(int stepIndex, WorkflowStepDefinition step, WorkflowExecutionContext context) {
        this.name = step.getName();
        this.stepIndex = stepIndex;
        this.stepDefinitionDeclaredId = step.id;
        this.context = context;
        this.input = MutableMap.copyOf(step.getInput());
    }

    public Throwable getError() {
        if (this.error == null && this.errorRecord != null) {
            this.error = this.errorRecord.getError();
        }
        return this.error;
    }

    void setError(Throwable t) {
        this.error = t;
        this.errorRecord = new LossySerializingThrowable(this.error);
    }

    @JsonGetter(value="error")
    String getErrorForJson() {
        return Exceptions.collapseText((Throwable)this.error);
    }

    @JsonSetter(value="error")
    void setErrorFromJson(String error) {
        this.setError(new RuntimeException(error));
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void injectContext(WorkflowExecutionContext context) {
        if (this.context != null && this.context != context) {
            throw new IllegalStateException("Cannot change context, from " + this.context + " to " + context);
        }
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public int getStepIndex() {
        return this.stepIndex;
    }

    public <T> T getInput(ConfigKey<T> key) {
        return this.getInput(key.getName(), key.getTypeToken());
    }

    public <T> T getInputOrDefault(ConfigKey<T> key) {
        Object result = this.getInput(key.getName(), key.getTypeToken());
        if (result == null && !this.input.containsKey(key.getName())) {
            result = key.getDefaultValue();
        }
        return result;
    }

    public Object getInput(String key) {
        ConfigKey<?> keyTyped = ConfigUtilsInternal.findConfigKeys(this.getClass(), null).get(key);
        if (keyTyped != null) {
            return this.getInput(keyTyped);
        }
        return this.getInput(key, Object.class);
    }

    public <T> T getInput(String key, Class<T> type) {
        return this.getInput(key, TypeToken.of(type));
    }

    public <T> T getInput(String key, TypeToken<T> type) {
        return this.getInput(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, key, type);
    }

    public boolean hasInput(ConfigKey<?> key) {
        return this.hasInput(key.getName());
    }

    public boolean hasInput(String key) {
        return this.input.containsKey(key);
    }

    public <T> T getInput(WorkflowExpressionResolution.WorkflowExpressionStage stage, String key, TypeToken<T> type) {
        Object v2;
        if (this.inputResolved.containsKey(key)) {
            return (T)this.inputResolved.get(key);
        }
        Object v = this.input.get(key);
        if (!Objects.equals(v, v2 = WorkflowExpressionResolution.allowingRecursionWhenSetting(this.context, WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, key, () -> this.context.resolve(stage, v, type)))) {
            this.inputResolved.put(key, v2);
        }
        return (T)v2;
    }

    public Object getInputRaw(String key) {
        return this.input.get(key);
    }

    @JsonIgnore
    public Entity getEntity() {
        return this.context.getEntity();
    }

    @JsonIgnore
    public WorkflowExecutionContext getWorkflowExectionContext() {
        return this.context;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object output) {
        this.outputOld = output;
        this.output = output;
    }

    @JsonIgnore
    public Object getPreviousStepOutput() {
        return this.getWorkflowExectionContext().getPreviousStepOutput();
    }

    public void setStepState(Object stepState, boolean persist) {
        this.stepState = stepState;
        if (persist) {
            this.getWorkflowExectionContext().persist();
        }
    }

    Object getStepState() {
        return this.stepState;
    }

    public Set<BrooklynTaskTags.WorkflowTaskTag> getSubWorkflows() {
        return this.subWorkflows;
    }

    public TypeToken<?> lookupType(String type, Supplier<TypeToken<?>> ifUnset) {
        return this.context.lookupType(type, ifUnset);
    }

    public Object resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, String expression) {
        return this.context.resolve(stage, expression);
    }

    public <T> T resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, Class<T> type) {
        return this.context.resolve(stage, expression, type);
    }

    public <T> T resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type) {
        return this.context.resolve(stage, expression, type);
    }

    public <T> T resolveWrapped(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type, WorkflowExpressionResolution.WrappingMode wrappingMode) {
        return this.context.resolveWrapped(stage, expression, type, wrappingMode);
    }

    public <T> T resolveWaiting(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type) {
        return this.context.resolveWaiting(stage, expression, type);
    }

    @JsonIgnore
    public String getWorkflowStepReference() {
        return this.context == null ? "unknown-" + this.stepDefinitionDeclaredId + "-" + this.stepIndex : this.context.getWorkflowStepReference(this.stepIndex, this.stepDefinitionDeclaredId, this.getError() != null);
    }

    @JsonIgnore
    public ManagementContext getManagementContext() {
        return this.getWorkflowExectionContext().getManagementContext();
    }

    public void noteOtherMetadata(String key, Object value) {
        this.noteOtherMetadata(key, value, true);
    }

    public void noteOtherMetadata(String key, Object value, boolean includeInLogs) {
        if (includeInLogs) {
            log.debug(this.getWorkflowStepReference() + " note metadata '" + key + "': " + value);
        }
        this.otherMetadata.put(key, value);
    }

    public String toString() {
        return "WorkflowStepInstanceExecutionContext{" + this.getWorkflowStepReference() + " / " + this.getName() + "}";
    }

    private WorkflowStepInstanceExecutionContext readResolve() {
        if (this.errorLegacyDeserialized != null && this.errorRecord == null) {
            this.setError(this.errorLegacyDeserialized);
            this.errorLegacyDeserialized = null;
        }
        return this;
    }
}

