/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class CloudStackSecurityGroupExtension
implements SecurityGroupExtension {
    protected final CloudStackApi api;
    protected final Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter;
    protected final LoadingCache<ZoneAndName, SecurityGroup> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final Supplier<Set<? extends Location>> locations;
    protected final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    protected final Predicate<String> jobComplete;

    @Inject
    public CloudStackSecurityGroupExtension(CloudStackApi api, Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter, LoadingCache<ZoneAndName, SecurityGroup> groupCreator, GroupNamingConvention.Factory namingConvention, @Memoized Supplier<Set<? extends Location>> locations, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, Predicate<String> jobComplete) {
        this.api = (CloudStackApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.groupConverter = (Function)Preconditions.checkNotNull(groupConverter, (Object)"groupConverter");
        this.groupCreator = (LoadingCache)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.blockUntilJobCompletesAndReturnResult = (BlockUntilJobCompletesAndReturnResult)Preconditions.checkNotNull((Object)blockUntilJobCompletesAndReturnResult, (Object)"blockUntilJobCompletesAndReturnResult");
        this.jobComplete = (Predicate)Preconditions.checkNotNull(jobComplete, (Object)"jobComplete");
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroups() {
        Set<SecurityGroup> rawGroups = this.api.getSecurityGroupApi().listSecurityGroups(new ListSecurityGroupsOptions[0]);
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsInLocation(Location location) {
        return this.listSecurityGroups();
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsForNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Set<SecurityGroup> rawGroups = this.api.getSecurityGroupApi().listSecurityGroups(ListSecurityGroupsOptions.Builder.virtualMachineId(id));
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public org.jclouds.compute.domain.SecurityGroup getSecurityGroupById(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        SecurityGroup rawGroup = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (rawGroup == null) {
            return null;
        }
        return (org.jclouds.compute.domain.SecurityGroup)this.groupConverter.apply((Object)rawGroup);
    }

    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, Location location) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)location, (Object)"location");
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        ZoneSecurityGroupNamePortsCidrs zoneAndName = ((ZoneSecurityGroupNamePortsCidrs.Builder)((ZoneSecurityGroupNamePortsCidrs.Builder)ZoneSecurityGroupNamePortsCidrs.builder().zone(location.getId())).name(markerGroup)).build();
        return (org.jclouds.compute.domain.SecurityGroup)this.groupConverter.apply((Object)((SecurityGroup)this.groupCreator.getUnchecked((Object)zoneAndName)));
    }

    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        SecurityGroup group = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (group == null) {
            this.invalidateCache(id);
            return false;
        }
        for (IngressRule rule : group.getIngressRules()) {
            this.jobComplete.apply((Object)this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
        }
        this.api.getSecurityGroupApi().deleteSecurityGroup(id);
        this.invalidateCache(id);
        return true;
    }

    private void invalidateCache(String id) {
        for (Map.Entry sg : this.groupCreator.asMap().entrySet()) {
            if (!id.equals(((SecurityGroup)sg.getValue()).getId())) continue;
            this.groupCreator.invalidate(sg.getKey());
            break;
        }
    }

    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        String id = (String)Preconditions.checkNotNull((Object)group.getId(), (Object)"group.getId()");
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            this.jobComplete.apply((Object)this.api.getSecurityGroupApi().authorizeIngressPortsToCIDRs(id, ipPermission.getIpProtocol().toString().toUpperCase(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getCidrBlocks(), new AccountInDomainOptions[0]));
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            this.jobComplete.apply((Object)this.api.getSecurityGroupApi().authorizeIngressPortsToSecurityGroups(id, ipPermission.getIpProtocol().toString().toUpperCase(), ipPermission.getFromPort(), ipPermission.getToPort(), (Multimap<String, String>)ipPermission.getTenantIdGroupNamePairs(), new AccountInDomainOptions[0]));
        }
        return this.getSecurityGroupById(id);
    }

    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        String id = (String)Preconditions.checkNotNull((Object)group.getId(), (Object)"group.getId()");
        SecurityGroup rawGroup = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (IngressRule rule : Iterables.filter(rawGroup.getIngressRules(), SecurityGroupPredicates.ruleCidrMatches(ipPermission.getIpProtocol().toString(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getCidrBlocks()))) {
                this.jobComplete.apply((Object)this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
            }
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            for (IngressRule rule : Iterables.filter(rawGroup.getIngressRules(), SecurityGroupPredicates.ruleGroupMatches(ipPermission.getIpProtocol().toString(), ipPermission.getFromPort(), ipPermission.getToPort(), (Multimap<String, String>)ipPermission.getTenantIdGroupNamePairs()))) {
                this.jobComplete.apply((Object)this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
            }
        }
        return this.getSecurityGroupById(id);
    }

    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return true;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return false;
    }

    public boolean supportsPortRangesForGroups() {
        return false;
    }

    public boolean supportsExclusionCidrBlocks() {
        return false;
    }
}

