/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TypeTokens {
    public static final Map<Class<?>, TypeToken<?>> COMMON_TYPE_TOKENS = ImmutableMap.builder().put(String.class, (Object)TypeToken.of(String.class)).put(Object.class, (Object)TypeToken.of(Object.class)).put(Integer.class, (Object)TypeToken.of(Integer.class)).put(Boolean.class, (Object)TypeToken.of(Boolean.class)).put(Double.class, (Object)TypeToken.of(Double.class)).put(Long.class, (Object)TypeToken.of(Long.class)).build();

    @Nullable
    public static <T> Class<? super T> getRawTypeIfRaw(@Nullable TypeToken<T> type) {
        if (type == null || !TypeTokens.isRaw(type)) {
            return null;
        }
        return type.getRawType();
    }

    @Nullable
    public static <T> TypeToken<T> getTypeTokenIfNotRaw(@Nullable TypeToken<T> type) {
        if (type == null || TypeTokens.isRaw(type)) {
            return null;
        }
        return type;
    }

    public static <T, U extends T> Class<T> getRawType(TypeToken<U> token, Class<T> raw) {
        if (raw != null) {
            return raw;
        }
        if (token != null) {
            if (token.getType() instanceof JavaType) {
                return ((JavaType)token.getType()).getRawClass();
            }
            return token.getRawType();
        }
        throw new IllegalStateException("Both indicators of type are null");
    }

    public static <T> TypeToken<T> getTypeToken(TypeToken<T> token, Class<? super T> raw) {
        if (token != null) {
            return token;
        }
        if (raw != null) {
            TypeToken result = COMMON_TYPE_TOKENS.get(raw);
            if (result == null) {
                result = TypeToken.of(raw);
            }
            return result;
        }
        throw new IllegalStateException("Both indicators of type are null");
    }

    public static <T> Class<T> getRawRawType(TypeToken<T> token) {
        return TypeTokens.getRawType(token, null);
    }

    public static <T> void checkCompatibleOneNonNull(Class<? super T> type, TypeToken<T> typeToken) {
        if (type == null && typeToken != null || type != null && typeToken == null) {
            return;
        }
        if (type == null && typeToken == null) {
            throw new NullPointerException("Type not set (neither class or type token)");
        }
        if (!TypeTokens.equalsRaw(type, typeToken)) {
            throw new IllegalStateException("Invalid types, token is " + typeToken + " (raw " + TypeTokens.getRawRawType(typeToken) + ") but class is " + type);
        }
    }

    public static List<TypeToken<?>> getGenericArguments(TypeToken<?> token) {
        Type t = token.getType();
        if (t instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)t).getActualTypeArguments()).map(TypeToken::of).collect(Collectors.toList());
        }
        return null;
    }

    public static <T> TypeToken<?> getComponentType(TypeToken<T> tt) {
        if (tt.getType() instanceof JavaType) {
            return TypeToken.of((Type)((JavaType)tt.getType()).getContentType());
        }
        return tt.getComponentType();
    }

    public static <T> boolean isArray(TypeToken<T> tt) {
        if (tt.getType() instanceof JavaType) {
            return tt.getType() instanceof ArrayType;
        }
        return tt.isArray();
    }

    public static <T> boolean isRaw(TypeToken<T> type) {
        return type.equals((Object)TypeToken.of(TypeTokens.getRawRawType(type)));
    }

    public static boolean equalsRaw(Class<?> clazz, TypeToken<?> tt) {
        return clazz.equals(TypeTokens.getRawRawType(tt));
    }

    public static boolean isAssignableFromRaw(Class<?> clazz, TypeToken<?> tt) {
        return clazz.isAssignableFrom(TypeTokens.getRawRawType(tt));
    }

    public static boolean isAssignableFromRaw(TypeToken<?> tt, Class<?> clazz) {
        return TypeTokens.getRawRawType(tt).isAssignableFrom(clazz);
    }

    public static <T> boolean isInstanceRaw(TypeToken<T> typeT, Object v) {
        return TypeTokens.getRawRawType(typeT).isInstance(v);
    }

    public static TypeToken<?> resolveType(TypeToken<?> tt, Type t) {
        if (tt.getType() instanceof JavaType) {
            return TypeToken.of(TypeTokens.getRawRawType(tt)).resolveType(t);
        }
        return tt.resolveType(t);
    }

    public static TypeToken<?>[] getGenericParameterTypeTokens(TypeToken<?> t) {
        Class<?> rawType = TypeTokens.getRawRawType(t);
        TypeVariable<Class<?>>[] pT = rawType.getTypeParameters();
        TypeToken[] pTT = new TypeToken[pT.length];
        for (int i = 0; i < pT.length; ++i) {
            pTT[i] = TypeTokens.resolveType(t, pT[i]);
        }
        return pTT;
    }

    public static <T> TypeToken<?>[] getGenericParameterTypeTokensWhenUpcastToClass(TypeToken<T> t, Class<? super T> clazz) {
        if (!clazz.isAssignableFrom(TypeTokens.getRawRawType(t))) {
            return new TypeToken[0];
        }
        return TypeTokens.getGenericParameterTypeTokens(t.getSupertype(clazz));
    }

    public static <T> TypeToken<?>[] getGenericParameterTypeTokensWhenUpcastToClassRaw(TypeToken<?> t, Class<?> clazz) {
        return TypeTokens.getGenericParameterTypeTokensWhenUpcastToClass(t, clazz);
    }

    @Beta
    public static TypeToken<?> union(TypeToken<?> t1, TypeToken<?> t2, boolean ignoreObject) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (ignoreObject) {
            if (t1.getRawType().equals(Object.class)) {
                return t2;
            }
            if (t2.getRawType().equals(Object.class)) {
                return t1;
            }
        }
        if (t1.getRawType().equals(t2.getRawType())) {
            TypeToken<?>[] tokens1 = TypeTokens.getGenericParameterTypeTokens(t1);
            TypeToken<?>[] tokens2 = TypeTokens.getGenericParameterTypeTokens(t1);
            if (tokens1.length > 0 && tokens2.length > 0) {
                TypeToken<?> union0 = TypeTokens.union(tokens1[0], tokens2[0], true);
                if (union0 == tokens2[0]) {
                    return t2;
                }
                return t1;
            }
            if (tokens2.length > 0) {
                return t2;
            }
            return t1;
        }
        if (t1.isSupertypeOf(t2)) {
            return t1;
        }
        if (t2.isSupertypeOf(t1)) {
            return t2;
        }
        if (t1.getRawType().isAssignableFrom(t2.getRawType())) {
            return t1;
        }
        if (t2.getRawType().isAssignableFrom(t1.getRawType())) {
            return t2;
        }
        return t1;
    }
}

