/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.BundleApi;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.domain.BundleInstallationRestResult;
import org.apache.brooklyn.rest.domain.BundleSummary;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.resources.TypeResource;
import org.apache.brooklyn.rest.transform.TypeTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.InputStreamSource;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class BundleResource
extends AbstractBrooklynRestResource
implements BundleApi {
    private static final Logger log = LoggerFactory.getLogger(BundleResource.class);
    private static final String LATEST = "latest";

    public List<BundleSummary> list(String versions, boolean detail) {
        return this.list((Predicate<String>)Predicates.alwaysTrue(), TypeResource.isLatestOnly(versions, true), detail);
    }

    private List<BundleSummary> list(Predicate<String> symbolicNameFilter, boolean onlyLatest, boolean detail) {
        TreeMap<VersionedName, ManagedBundle> bundles = new TreeMap<VersionedName, ManagedBundle>((Comparator<VersionedName>)VersionedName.VersionedNameComparator.INSTANCE);
        for (ManagedBundle b : ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).getManagedBundles().values()) {
            VersionedName key;
            ManagedBundle oldBundle;
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)b.getId()) || !symbolicNameFilter.apply((Object)b.getSymbolicName()) || (oldBundle = (ManagedBundle)bundles.get(key = onlyLatest ? new VersionedName(b.getSymbolicName(), LATEST) : b.getVersionedName())) != null && oldBundle.getVersionedName().compareTo(b.getVersionedName()) <= 0) continue;
            bundles.put(key, b);
        }
        return this.toBundleSummary(bundles.values(), detail);
    }

    private List<BundleSummary> toBundleSummary(Iterable<ManagedBundle> sortedItems, boolean detail) {
        MutableList result = MutableList.of();
        for (ManagedBundle t : sortedItems) {
            result.add(TypeTransformer.bundleSummary(this.brooklyn(), t, this.ui.getBaseUriBuilder(), this.mgmt(), detail));
        }
        return result;
    }

    public List<BundleSummary> listVersions(String symbolicName, boolean detail) {
        return this.list((Predicate<String>)Predicates.equalTo((Object)symbolicName), false, detail);
    }

    public BundleSummary detail(String symbolicName, String version) {
        ManagedBundle b = this.lookup(symbolicName, version);
        return TypeTransformer.bundleDetails(this.brooklyn(), b, this.ui.getBaseUriBuilder(), this.mgmt());
    }

    protected ManagedBundle lookup(String symbolicName, String version) {
        ManagedBundle b = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).getManagedBundle(new VersionedName(symbolicName, version));
        if (b == null) {
            throw WebResourceUtils.notFound("Bundle with id '%s:%s' not found", symbolicName, version);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)b.getId())) {
            throw WebResourceUtils.notFound("Bundle with id '%s:%s' not found", symbolicName, version);
        }
        return b;
    }

    public Response download(String symbolicName, String version) {
        ManagedBundle managedBundle = this.lookup(symbolicName, version);
        File bundleFile = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).getBundleFile(managedBundle);
        if (bundleFile == null || !bundleFile.exists()) {
            throw WebResourceUtils.notFound("Bundle with id '%s:%s' doesn't have a ZIP archive found", symbolicName, version);
        }
        log.debug("Download of bundle " + managedBundle + " by user " + Entitlements.getEntitlementContext().user());
        try {
            return Response.ok((Object)FileUtils.readFileToByteArray((File)bundleFile), (String)"application/zip").header("Content-Disposition", (Object)("attachment; filename=" + symbolicName + "-" + version + ".zip")).build();
        }
        catch (IOException e) {
            throw WebResourceUtils.serverError("Cannot read the ZIP archive for bundle '%s:%s'", symbolicName, version);
        }
    }

    public List<TypeSummary> getTypes(String symbolicName, String version) {
        ManagedBundle b = this.lookup(symbolicName, version);
        return TypeTransformer.bundleDetails(this.brooklyn(), b, this.ui.getBaseUriBuilder(), this.mgmt()).getTypes();
    }

    public TypeDetail getType(String symbolicName, String version, String typeSymbolicName) {
        return this.getTypeExplicitVersion(symbolicName, version, typeSymbolicName, version);
    }

    public TypeDetail getTypeExplicitVersion(String symbolicName, String version, String typeSymbolicName, String typeVersion) {
        RegisteredType item = this.getRegisteredType(symbolicName, version, typeSymbolicName, typeVersion);
        return TypeTransformer.detail(this.brooklyn(), item, this.ui.getBaseUriBuilder());
    }

    private RegisteredType getRegisteredType(String symbolicName, String version, String typeSymbolicName, String typeVersion) {
        Iterable items;
        ManagedBundle b = this.lookup(symbolicName, version);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(typeSymbolicName + ":" + typeVersion))) {
            throw WebResourceUtils.forbidden("User '%s' not permitted to see info on this type (including whether or not installed)", Entitlements.getEntitlementContext().user());
        }
        Predicate pred = RegisteredTypePredicates.nameOrAlias((String)typeSymbolicName);
        pred = Predicates.and((Predicate)pred, (Predicate)RegisteredTypePredicates.containingBundle((VersionedName)b.getVersionedName()));
        if (!LATEST.equalsIgnoreCase(typeVersion)) {
            pred = Predicates.and((Predicate)pred, (Predicate)RegisteredTypePredicates.version((String)typeVersion));
        }
        if (Iterables.isEmpty((Iterable)(items = this.mgmt().getTypeRegistry().getMatching(pred)))) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", typeSymbolicName, typeVersion);
        }
        return RegisteredTypes.getBestVersion((Iterable)items);
    }

    public Response getTypeExplicitVersionIcon(String symbolicName, String version, String typeSymbolicName, String typeVersion) {
        RegisteredType item = this.getRegisteredType(symbolicName, version, typeSymbolicName, typeVersion);
        return TypeResource.produceIcon(this.mgmt(), this.brooklyn(), item);
    }

    public BundleInstallationRestResult remove(String symbolicName, String version, Boolean force) {
        ManagedBundle b = this.lookup(symbolicName, version);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(symbolicName + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to remove catalog item '%s:%s'", Entitlements.getEntitlementContext().user(), symbolicName, version);
        }
        log.info("REST removing " + symbolicName + ":" + version);
        if (force == null) {
            force = false;
        }
        ReferenceWithError r = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).uninstallUploadedBundle(b, force.booleanValue());
        return TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)r.getWithoutError(), this.mgmt(), this.brooklyn(), this.ui);
    }

    @Deprecated
    public Response createFromYaml(String yaml, Boolean force) {
        return this.create(yaml.getBytes(), "brooklyn-bom-yaml", force);
    }

    @Deprecated
    public Response createFromArchive(byte[] zipInput, Boolean force) {
        return this.create(zipInput, "brooklyn-bom-bundle", force);
    }

    public Response create(byte[] contents, String format, Boolean force) {
        Response.Status status;
        ReferenceWithError result;
        InputStreamSource source = InputStreamSource.of((String)"REST bundle upload", (byte[])contents);
        if (!"brooklyn-bom-yaml".equals(format) && FileUtil.doesZipContainJavaBinaries((InputStreamSource)source) && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_JAVA, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog item containing java classes", Entitlements.getEntitlementContext().user());
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_CATALOG_ITEM, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog item", Entitlements.getEntitlementContext().user());
        }
        if (force == null) {
            force = false;
        }
        if ((result = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).install((Supplier)source, format, force.booleanValue(), Boolean.valueOf(true))).hasError()) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to create from archive, returning 400: " + result.getError().getMessage(), result.getError());
            }
            ApiError.Builder error = ApiError.builder().errorCode(Response.Status.BAD_REQUEST);
            if (result.getWithoutError() != null) {
                error = error.message(((OsgiBundleInstallationResult)result.getWithoutError()).getMessage()).data((Object)TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.getWithoutError(), this.mgmt(), this.brooklyn(), this.ui));
            } else {
                error.message(Strings.isNonBlank((CharSequence)result.getError().getMessage()) ? result.getError().getMessage() : result.getError().toString());
            }
            return error.build().asJsonResponse();
        }
        BundleInstallationRestResult resultR = TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.get(), this.mgmt(), this.brooklyn(), this.ui);
        switch (((OsgiBundleInstallationResult)result.get()).getCode()) {
            case IGNORING_BUNDLE_AREADY_INSTALLED: 
            case IGNORING_BUNDLE_FORCIBLY_REMOVED: {
                status = Response.Status.OK;
                break;
            }
            default: {
                status = Response.Status.CREATED;
            }
        }
        return Response.status((Response.Status)status).entity((Object)resultR).build();
    }

    public Response getIcon(String symbolicName, String version) {
        ManagedBundle b = this.lookup(symbolicName, version);
        Optional<String> iconUrl = Optional.ofNullable(BrooklynTags.findFirstNamedStringTag((String)"icon_url", (Iterable)b.tags().getTags())).map(BrooklynTags.NamedStringTag::getContents);
        if (!iconUrl.isPresent()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        String url = iconUrl.get();
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            InputStream content = ResourceUtils.create((Object)b).getResourceFromUrl(url);
            return Response.ok((Object)content, (MediaType)mime).build();
        }
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }
}

