/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine.pool;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.location.dynamic.LocationOwner;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.machine.MachineEntity;
import org.apache.brooklyn.entity.machine.pool.ServerPoolImpl;
import org.apache.brooklyn.entity.machine.pool.ServerPoolLocation;

@Catalog(name="Server Pool", description="Creates a pre-allocated server pool, which other applications can deploy to")
@ImplementedBy(value=ServerPoolImpl.class)
@Beta
public interface ServerPool
extends DynamicCluster,
LocationOwner<ServerPoolLocation, ServerPool> {
    public static final ConfigKey<String> LOCATION_NAME_PREFIX = ConfigKeys.newConfigKeyWithDefault((ConfigKey)LocationOwner.LOCATION_NAME_PREFIX, (Object)"server-pool");
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)2);
    public static final AttributeSensor<Integer> AVAILABLE_COUNT = Sensors.newIntegerSensor((String)"pool.available", (String)"The number of locations in the pool that are unused");
    public static final AttributeSensor<Integer> CLAIMED_COUNT = Sensors.newIntegerSensor((String)"pool.claimed", (String)"The number of locations in the pool that are in use");
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(MachineEntity.class));
    public static final MethodEffector<Collection<Entity>> ADD_MACHINES_FROM_SPEC = new MethodEffector(ServerPool.class, "addExistingMachinesFromSpec");

    public MachineLocation claimMachine(Map<?, ?> var1) throws NoMachinesAvailableException;

    public void releaseMachine(MachineLocation var1);

    public Entity addExistingMachine(MachineLocation var1);

    @Effector(description="Adds additional machines to the pool by resolving the given spec.")
    public Collection<Entity> addExistingMachinesFromSpec(@EffectorParam(name="spec", description="Spec") String var1);
}

