/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.Callable;
import javax.inject.Named;

public class ProvisioningJob
implements Callable {
    private final Predicate<String> waitDataCenterUntilReady;
    private final String group;
    private final Supplier<Object> operation;

    @Inject
    ProvisioningJob(@Named(value="jclouds.profitbricks.predicate.datacenter") Predicate<String> waitDataCenterUntilReady, @Assisted String group, @Assisted Supplier<Object> operation) {
        this.waitDataCenterUntilReady = waitDataCenterUntilReady;
        this.group = (String)Preconditions.checkNotNull((Object)group, (Object)"group cannot be null");
        this.operation = (Supplier)Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
    }

    public Object call() throws Exception {
        this.waitDataCenterUntilReady.apply((Object)this.group);
        Object obj = this.operation.get();
        this.waitDataCenterUntilReady.apply((Object)this.group);
        return obj;
    }

    public String getGroup() {
        return this.group;
    }

    public static interface Factory {
        public ProvisioningJob create(String var1, Supplier<Object> var2);
    }
}

