/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.qpid;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.messaging.qpid.QpidDestinationImpl;
import org.apache.brooklyn.entity.messaging.qpid.QpidQueue;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class QpidQueueImpl
extends QpidDestinationImpl
implements QpidQueue {
    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        this.sensors().set((AttributeSensor)QUEUE_NAME, (Object)this.getName());
        try {
            this.exchange = new ObjectName(String.format("org.apache.qpid:type=VirtualHost.Exchange,VirtualHost=\"%s\",name=\"%s\",ExchangeType=direct", this.virtualHost, this.getExchangeName()));
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected void connectSensors() {
        String queue = String.format("org.apache.qpid:type=VirtualHost.Queue,VirtualHost=\"%s\",name=\"%s\"", this.virtualHost, this.getName());
        this.jmxFeed = JmxFeed.builder().entity((Entity)this).helper(this.jmxHelper).pollAttribute(new JmxAttributePollConfig(QUEUE_DEPTH_BYTES).objectName(queue).attributeName("QueueDepth")).pollAttribute(new JmxAttributePollConfig(QUEUE_DEPTH_MESSAGES).objectName(queue).attributeName("MessageCount")).build();
    }

    @Override
    public String getExchangeName() {
        return "amq.direct";
    }
}

