/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.EnumerationUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSessionAttributeAdapter {
    private static final Logger log = LoggerFactory.getLogger(MultiSessionAttributeAdapter.class);
    private static final String KEY_PREFERRED_SESSION_HANDLER_INSTANCE = "org.apache.brooklyn.server.PreferredSessionHandlerInstance";
    private static final String KEY_IS_PREFERRED = "org.apache.brooklyn.server.IsPreferred";
    public static final ConfigKey<Long> MAX_SESSION_AGE = ConfigKeys.newLongConfigKey((String)"org.apache.brooklyn.server.maxSessionAge", (String)"Max session age in seconds");
    public static final ConfigKey<Integer> MAX_INACTIVE_INTERVAL = ConfigKeys.newIntegerConfigKey((String)"org.apache.brooklyn.server.maxInactiveInterval", (String)"Max inactive interval in seconds", (Integer)3600);
    private static final Object PREFERRED_SYMBOLIC_NAME = "org.apache.cxf.cxf-rt-transports-http";
    private final HttpSession preferredSession;
    private final HttpSession localSession;
    private final ManagementContext mgmt;
    private boolean silentlyAcceptLocalOnlyValues = false;
    private boolean setLocalValuesAlso = false;
    private boolean setAllKnownSessions = false;
    private static final Factory FACTORY = new Factory();

    protected MultiSessionAttributeAdapter(HttpSession preferredSession, HttpSession localSession, HttpServletRequest request) {
        this.preferredSession = preferredSession;
        this.localSession = localSession;
        ServletContext servletContext = request != null ? request.getServletContext() : (localSession != null ? localSession.getServletContext() : (preferredSession != null ? preferredSession.getServletContext() : null));
        this.mgmt = servletContext != null ? new ManagementContextProvider(servletContext).getManagementContext() : null;
        this.resetExpiration();
    }

    public MultiSessionAttributeAdapter(HttpSession preferredSession, HttpSession session) {
        this(preferredSession, session, null);
    }

    public static MultiSessionAttributeAdapter of(HttpServletRequest r) {
        return MultiSessionAttributeAdapter.of(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiSessionAttributeAdapter of(HttpServletRequest r, boolean create) {
        HttpSession localSession = r.getSession(create);
        HttpSession preferredSession = null;
        if (localSession == null) {
            preferredSession = MultiSessionAttributeAdapter.FACTORY.findValidPreferredSession(null, r);
            if (preferredSession != null) {
                if (r instanceof Request) {
                    SessionHandler sessionHandler = ((Request)r).getSessionHandler();
                    synchronized (sessionHandler) {
                        try {
                            String id = ((Request)r).getSessionHandler().getSessionIdManager().newSessionId(r, System.currentTimeMillis());
                            localSession = ((Request)r).getSessionHandler().getSession(id);
                        }
                        catch (Exception e) {
                            log.debug("Unable to retrieve session via safe override, falling back to default: " + e);
                        }
                        if (localSession == null) {
                            localSession = r.getSession();
                        }
                    }
                }
                localSession = r.getSession();
            }
        } else {
            preferredSession = MultiSessionAttributeAdapter.FACTORY.findPreferredSession(r);
        }
        if (preferredSession == null) {
            return null;
        }
        return new MultiSessionAttributeAdapter(preferredSession, localSession, r);
    }

    public static MultiSessionAttributeAdapter of(HttpSession session) {
        return new MultiSessionAttributeAdapter(MultiSessionAttributeAdapter.FACTORY.findPreferredSession(session, null), session);
    }

    private static String getContextPath(Handler h) {
        ContextHandler.Context ctx;
        if (h instanceof SessionHandler && (ctx = MultiSessionAttributeAdapter.getContext((SessionHandler)h)) != null) {
            return ctx.getContextPath();
        }
        return null;
    }

    private static String getBundle(Handler h) {
        BundleContext bundle;
        ContextHandler.Context ctx;
        if (h instanceof SessionHandler && (ctx = MultiSessionAttributeAdapter.getContext((SessionHandler)h)) != null && (bundle = (BundleContext)ctx.getAttribute("osgi-bundlecontext")) != null) {
            return bundle.getBundle().getSymbolicName();
        }
        return null;
    }

    private static String getContextPath(HttpSession h) {
        if (h instanceof Session) {
            return MultiSessionAttributeAdapter.getContextPath((Handler)((Session)h).getSessionHandler());
        }
        return null;
    }

    private static String getBundle(HttpSession h) {
        BundleContext bundle;
        ContextHandler.Context ctx;
        if (h instanceof Session && (ctx = MultiSessionAttributeAdapter.getContext(((Session)h).getSessionHandler())) != null && (bundle = (BundleContext)ctx.getAttribute("osgi-bundlecontext")) != null) {
            return bundle.getBundle().getSymbolicName();
        }
        return null;
    }

    protected static ContextHandler.Context getContext(SessionHandler sh) {
        try {
            Field f = SessionHandler.class.getDeclaredField("_context");
            f.setAccessible(true);
            return (ContextHandler.Context)f.get(sh);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return null;
        }
    }

    private static String info(HttpServletRequest req, HttpSession sess) {
        if (req != null) {
            return MultiSessionAttributeAdapter.info(req);
        }
        return MultiSessionAttributeAdapter.info(sess);
    }

    public static String info(HttpServletRequest r) {
        if (r == null) {
            return "null";
        }
        return "" + r + "[" + r.getRequestURI() + "@" + MultiSessionAttributeAdapter.info(r.getSession(false)) + "]";
    }

    public static String info(SessionHandler h) {
        if (h == null) {
            return "null";
        }
        return "" + h + "[" + (Strings.isBlank((CharSequence)MultiSessionAttributeAdapter.getContextPath((Handler)h)) ? MultiSessionAttributeAdapter.getBundle((Handler)h) : MultiSessionAttributeAdapter.getContextPath((Handler)h)) + "]";
    }

    public static String info(HttpSession s) {
        if (s == null) {
            return "null";
        }
        String hh = MultiSessionAttributeAdapter.getContextPath(s);
        if (Strings.isBlank((CharSequence)hh)) {
            hh = MultiSessionAttributeAdapter.getBundle(s);
        }
        if (Strings.isBlank((CharSequence)hh)) {
            hh = s instanceof Session ? MultiSessionAttributeAdapter.info(((Session)s).getSessionHandler()) : "<non-jetty>";
        }
        return "" + s + "[" + s.getId() + " @ " + hh + "]";
    }

    public MultiSessionAttributeAdapter configureWhetherToSilentlyAcceptLocalOnlyValues(boolean silentlyAcceptLocalOnlyValues) {
        this.silentlyAcceptLocalOnlyValues = silentlyAcceptLocalOnlyValues;
        return this;
    }

    public MultiSessionAttributeAdapter configureWhetherToSetLocalValuesAlso(boolean setLocalValuesAlso) {
        this.setLocalValuesAlso = setLocalValuesAlso;
        return this;
    }

    public MultiSessionAttributeAdapter configureWhetherToSetInAll(boolean setAllKnownSessions) {
        this.setAllKnownSessions = setAllKnownSessions;
        return this;
    }

    public Object getAttribute(String name) {
        Object v = this.preferredSession.getAttribute(name);
        if (v == null && (v = this.localSession.getAttribute(name)) != null && !this.silentlyAcceptLocalOnlyValues) {
            log.warn(this + " found value for '" + name + "' in local session but not in preferred session; ensure value is written using this class if it is going to be read with this class");
            this.preferredSession.setAttribute(name, v);
        }
        return v;
    }

    public void setAttribute(String name, Object value) {
        if (this.setAllKnownSessions) {
            Handler[] hh = this.getSessionHandlers();
            if (hh != null) {
                for (Handler h : hh) {
                    Session ss = MultiSessionAttributeAdapter.getSessionSafely(h, this.localSession.getId());
                    if (ss == null) continue;
                    ss.setAttribute(name, value);
                }
                return;
            }
            if (!this.setLocalValuesAlso) {
                this.configureWhetherToSetLocalValuesAlso(true);
            }
        }
        this.preferredSession.setAttribute(name, value);
        if (this.setLocalValuesAlso) {
            this.localSession.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (this.setAllKnownSessions) {
            Handler[] hh = this.getSessionHandlers();
            if (hh != null) {
                for (Handler h : hh) {
                    Session ss = MultiSessionAttributeAdapter.getSessionSafely(h, this.localSession.getId());
                    if (ss == null) continue;
                    ss.removeAttribute(name);
                }
                return;
            }
            if (!this.setLocalValuesAlso) {
                this.configureWhetherToSetLocalValuesAlso(true);
            }
        }
        this.preferredSession.removeAttribute(name);
        if (this.setLocalValuesAlso) {
            this.localSession.removeAttribute(name);
        }
    }

    protected Handler[] getSessionHandlers() {
        Server srv = this.getServer();
        Handler[] handlers = null;
        if (srv != null) {
            handlers = srv.getChildHandlersByClass(SessionHandler.class);
        }
        return handlers;
    }

    protected Server getServer() {
        Server server = null;
        if (this.localSession instanceof Session && (server = ((Session)this.localSession).getSessionHandler().getServer()) != null) {
            return server;
        }
        if (this.preferredSession instanceof Session && (server = ((Session)this.preferredSession).getSessionHandler().getServer()) != null) {
            return server;
        }
        return null;
    }

    public HttpSession getPreferredSession() {
        return this.preferredSession;
    }

    public HttpSession getOriginalSession() {
        return this.localSession;
    }

    public String getId() {
        return this.getPreferredSession().getId();
    }

    public MultiSessionAttributeAdapter resetExpiration() {
        Handler[] hh;
        Integer maxInativeInterval = (Integer)MAX_INACTIVE_INTERVAL.getDefaultValue();
        if (this.mgmt != null) {
            maxInativeInterval = (Integer)this.mgmt.getConfig().getConfig(MAX_INACTIVE_INTERVAL);
        }
        if ((hh = this.getSessionHandlers()) != null) {
            for (Handler h : hh) {
                Session ss = MultiSessionAttributeAdapter.getSessionSafely(h, this.getId());
                if (ss == null) continue;
                ss.setMaxInactiveInterval(maxInativeInterval.intValue());
            }
        }
        return this;
    }

    private static Session getSessionSafely(Handler h, String id) {
        if (!(h instanceof SessionHandler)) {
            log.warn("Unexpected Handler type " + h + " / " + (h == null ? "null" : h.getClass()) + "; ignoring session lookup for " + id);
            return null;
        }
        if (((SessionHandler)h).getSessionCache() == null) {
            log.debug("Skipping session lookup for " + id + " on " + h + " because session cache not initialized (yet)");
            return null;
        }
        return ((SessionHandler)h).getSession(id);
    }

    protected static class Factory {
        protected Factory() {
        }

        private HttpSession findPreferredSession(HttpServletRequest r) {
            if (r.getSession(false) == null) {
                log.warn("Creating session", (Throwable)new Exception("source of created session"));
                r.getSession();
            }
            return this.findPreferredSession(r.getSession(), r);
        }

        private HttpSession findPreferredSession(HttpSession localSession, HttpServletRequest optionalRequest) {
            Long maxSessionAge;
            boolean isValid;
            ServletContext servletContext;
            HttpSession preferredSession = this.findValidPreferredSession(localSession, optionalRequest);
            ManagementContext mgmt = null;
            Object object = optionalRequest != null ? optionalRequest.getServletContext() : (localSession != null ? localSession.getServletContext() : (servletContext = preferredSession != null ? preferredSession.getServletContext() : null));
            if (servletContext != null) {
                mgmt = new ManagementContextProvider(servletContext).getManagementContext();
            }
            if (!(isValid = ((Session)preferredSession).isValid())) {
                throw new SessionExpiredException("Session invalidated", SessionErrors.SESSION_INVALIDATED, optionalRequest);
            }
            if (mgmt != null && (maxSessionAge = (Long)mgmt.getConfig().getConfig(MAX_SESSION_AGE)) != null && this.isAgeExceeded(preferredSession, maxSessionAge)) {
                this.invalidateAllSession(preferredSession, localSession);
                throw new SessionExpiredException("Max session age exceeded", SessionErrors.SESSION_AGE_EXCEEDED, optionalRequest);
            }
            return preferredSession;
        }

        private boolean isAgeExceeded(HttpSession preferredSession, Long maxSessionAge) {
            return preferredSession.getCreationTime() + maxSessionAge * 1000L < System.currentTimeMillis();
        }

        private void invalidateAllSession(HttpSession preferredSession, HttpSession localSession) {
            Server server = ((Session)preferredSession).getSessionHandler().getServer();
            Handler[] handlers = server.getChildHandlersByClass(SessionHandler.class);
            ArrayList<String> invalidatedSessions = new ArrayList<String>();
            if (handlers != null) {
                for (Handler h : handlers) {
                    Session session = MultiSessionAttributeAdapter.getSessionSafely(h, preferredSession.getId());
                    if (session == null) continue;
                    invalidatedSessions.add(session.getId());
                    session.invalidate();
                }
            }
            if (!invalidatedSessions.contains(localSession.getId())) {
                localSession.invalidate();
            }
        }

        private HttpSession findValidPreferredSession(HttpSession optionalLocalSession, HttpServletRequest optionalRequest) {
            SessionHandler someHandler;
            SessionHandler preferredHandler = null;
            Session preferredSession = null;
            if (optionalLocalSession instanceof Session) {
                preferredHandler = this.getPreferredJettyHandler((Session)optionalLocalSession, true, true);
            }
            if (preferredHandler == null && optionalRequest instanceof Request && (someHandler = ((Request)optionalRequest).getSessionHandler()) != null) {
                preferredHandler = this.getServerGlobalPreferredHandler(someHandler.getServer());
            }
            if (preferredHandler != null) {
                Cookie[] cookies;
                SessionHandler sh;
                SessionIdManager idManager;
                String id;
                String extendedId;
                String string = optionalLocalSession != null ? optionalLocalSession.getId() : (extendedId = optionalRequest != null ? optionalRequest.getRequestedSessionId() : null);
                if (Strings.isNonBlank((CharSequence)extendedId) && (preferredSession = MultiSessionAttributeAdapter.getSessionSafely((Handler)preferredHandler, id = (idManager = preferredHandler.getSessionIdManager()).getId(extendedId))) != null && !preferredSession.getExtendedId().equals(extendedId)) {
                    preferredSession.setIdChanged(true);
                }
                if (preferredSession == null && optionalRequest instanceof Request && (sh = ((Request)optionalRequest).getSessionHandler()).isUsingCookies() && (cookies = optionalRequest.getCookies()) != null && cookies.length > 0) {
                    String sessionCookie = SessionHandler.getSessionCookieName((SessionCookieConfig)sh.getSessionCookieConfig());
                    for (Cookie cookie : cookies) {
                        String requestedId;
                        SessionIdManager idManager2;
                        String globalSessionId;
                        if (!sessionCookie.equalsIgnoreCase(cookie.getName()) || (preferredSession = MultiSessionAttributeAdapter.getSessionSafely((Handler)preferredHandler, globalSessionId = (idManager2 = preferredHandler.getSessionIdManager()).getId(requestedId = cookie.getValue()))) == null) continue;
                        ((Request)optionalRequest).setRequestedSessionId(requestedId);
                        preferredSession.setIdChanged(true);
                        break;
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Preferred session for " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession) + ": " + (preferredSession != null ? MultiSessionAttributeAdapter.info(preferredSession) : "none, willl make new session in " + MultiSessionAttributeAdapter.info(preferredHandler)));
            }
            if (preferredSession != null) {
                return preferredSession;
            }
            if (optionalLocalSession instanceof Session) {
                if (preferredHandler != null) {
                    if (optionalRequest != null) {
                        HttpSession result = preferredHandler.newHttpSession(optionalRequest);
                        if (log.isTraceEnabled()) {
                            log.trace("Creating new session " + MultiSessionAttributeAdapter.info(result) + " to be preferred for " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession));
                        }
                        return result;
                    }
                    log.warn("No request so cannot create preferred session at preferred handler " + MultiSessionAttributeAdapter.info(preferredHandler) + " for " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession) + "; will exceptionally mark the calling session as the preferred one");
                    this.markSessionAsPreferred(optionalLocalSession, " (request came in for " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession) + ")");
                    return optionalLocalSession;
                }
                log.warn("Unexpected failure to find a handler for " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession));
            } else if (optionalLocalSession != null) {
                log.warn("Unsupported session impl in " + MultiSessionAttributeAdapter.info(optionalRequest, optionalLocalSession));
            }
            return optionalLocalSession;
        }

        private SessionHandler getPreferredJettyHandler(Session localSession, boolean allowHandlerThatDoesntHaveSession, boolean markAndReturnThisIfNoneFound) {
            SessionHandler localHandler = localSession.getSessionHandler();
            Server server = localHandler.getServer();
            if (server != null) {
                Session sessionAtServerGlobalPreferredHandler = null;
                SessionHandler preferredServerGlobalSessionHandler = this.getServerGlobalPreferredHandler(server);
                if (preferredServerGlobalSessionHandler != null && (sessionAtServerGlobalPreferredHandler = MultiSessionAttributeAdapter.getSessionSafely((Handler)preferredServerGlobalSessionHandler, localSession.getId())) != null && Boolean.TRUE.equals(sessionAtServerGlobalPreferredHandler.getAttribute(MultiSessionAttributeAdapter.KEY_IS_PREFERRED))) {
                    return preferredServerGlobalSessionHandler;
                }
                Handler[] handlers = server.getChildHandlersByClass(SessionHandler.class);
                SessionHandler preferredHandlerForMarkedSession = this.findPeerSessionMarkedPreferred(localSession.getId(), handlers);
                if (preferredHandlerForMarkedSession != null) {
                    return preferredHandlerForMarkedSession;
                }
                if (sessionAtServerGlobalPreferredHandler != null) {
                    sessionAtServerGlobalPreferredHandler.setAttribute(MultiSessionAttributeAdapter.KEY_IS_PREFERRED, (Object)true);
                    return preferredServerGlobalSessionHandler;
                }
                if (allowHandlerThatDoesntHaveSession && preferredServerGlobalSessionHandler != null) {
                    return preferredServerGlobalSessionHandler;
                }
                if (preferredServerGlobalSessionHandler == null && (preferredServerGlobalSessionHandler = this.findPreferredBundleHandler(localSession, server, handlers)) != null) {
                    return this.getPreferredJettyHandler(localSession, allowHandlerThatDoesntHaveSession, markAndReturnThisIfNoneFound);
                }
                if (markAndReturnThisIfNoneFound) {
                    this.markSessionAsPreferred((HttpSession)localSession, " (this is the handler that the request came in on)");
                    return localHandler;
                }
            } else {
                log.warn("Could not find server for " + MultiSessionAttributeAdapter.info((HttpSession)localSession));
            }
            return null;
        }

        protected void markSessionAsPreferred(HttpSession localSession, String msg) {
            if (log.isTraceEnabled()) {
                log.trace("Recording on " + MultiSessionAttributeAdapter.info(localSession) + " that it is the preferred session" + msg);
            }
            localSession.setAttribute(MultiSessionAttributeAdapter.KEY_IS_PREFERRED, (Object)true);
        }

        protected SessionHandler findPreferredBundleHandler(Session localSession, Server server, Handler[] handlers) {
            if (PREFERRED_SYMBOLIC_NAME == null) {
                return null;
            }
            SessionHandler preferredHandler = null;
            if (handlers != null) {
                for (Handler handler : handlers) {
                    BundleContext bundle;
                    SessionHandler sh = (SessionHandler)handler;
                    ContextHandler.Context ctx = MultiSessionAttributeAdapter.getContext(sh);
                    if (ctx == null || (bundle = (BundleContext)ctx.getAttribute("osgi-bundlecontext")) == null || !PREFERRED_SYMBOLIC_NAME.equals(bundle.getBundle().getSymbolicName())) continue;
                    if (preferredHandler == null) {
                        preferredHandler = sh;
                        server.setAttribute(MultiSessionAttributeAdapter.KEY_PREFERRED_SESSION_HANDLER_INSTANCE, (Object)sh);
                        log.trace("Recording " + MultiSessionAttributeAdapter.info(sh) + " as server-wide preferred session handler");
                        continue;
                    }
                    log.warn("Multiple preferred session handlers detected; keeping " + MultiSessionAttributeAdapter.info(preferredHandler) + ", ignoring " + MultiSessionAttributeAdapter.info(sh));
                }
            }
            if (preferredHandler == null) {
                log.warn("Did not find handler in bundle " + PREFERRED_SYMBOLIC_NAME + "; not using server-wide handler; check whether bundle is installed!");
            }
            return preferredHandler;
        }

        protected SessionHandler findPeerSessionMarkedPreferred(String localSessionId, Handler[] handlers) {
            SessionHandler preferredHandler = null;
            if (handlers != null) {
                for (Handler h : handlers) {
                    SessionHandler sh = (SessionHandler)h;
                    Session sessionHere = MultiSessionAttributeAdapter.getSessionSafely((Handler)sh, localSessionId);
                    if (sessionHere == null || !Boolean.TRUE.equals(sessionHere.getAttribute(MultiSessionAttributeAdapter.KEY_IS_PREFERRED))) continue;
                    if (preferredHandler != null) {
                        log.warn("Multiple sessions marked as preferred for " + localSessionId + "; using " + MultiSessionAttributeAdapter.info(preferredHandler) + " not " + MultiSessionAttributeAdapter.info(sh));
                        sessionHere.setAttribute(MultiSessionAttributeAdapter.KEY_IS_PREFERRED, null);
                        continue;
                    }
                    preferredHandler = sh;
                }
            }
            return preferredHandler;
        }

        protected SessionHandler getServerGlobalPreferredHandler(Server server) {
            SessionHandler preferredHandler = (SessionHandler)server.getAttribute(MultiSessionAttributeAdapter.KEY_PREFERRED_SESSION_HANDLER_INSTANCE);
            if (preferredHandler != null) {
                if (preferredHandler.isRunning()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Found " + MultiSessionAttributeAdapter.info(preferredHandler) + " as server-wide preferred handler");
                    }
                    return preferredHandler;
                }
                log.warn("Preferred session handler " + MultiSessionAttributeAdapter.info(preferredHandler) + " detected on server is not running; resetting");
            }
            return null;
        }

        private static Response buildExceptionResponse(SessionErrors error_status, HttpServletRequest optionalRequest, String message) {
            String responseData;
            String mediaType;
            if (Factory.requestIsHtml(optionalRequest)) {
                mediaType = "text/html";
                StringBuilder sb = new StringBuilder("<p>").append(message).append("</p>\n").append("<p>").append("Please go <a href=\"").append(optionalRequest.getRequestURL()).append("\">here</a> to refresh.").append("</p>");
                responseData = sb.toString();
            } else {
                mediaType = "application/json";
                JsonObject jsonEntity = new JsonObject();
                jsonEntity.addProperty(error_status.toString(), Boolean.valueOf(true));
                responseData = jsonEntity.toString();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).header(HttpHeader.CONTENT_TYPE.asString(), (Object)mediaType).entity((Object)responseData).build();
        }

        private static boolean requestIsHtml(HttpServletRequest optionalRequest) {
            ImmutableSet defaultMediaTypes;
            Set headerList = Factory.separateOneLineMediaTypes(EnumerationUtils.toList((Enumeration)optionalRequest.getHeaders("Accept")));
            return CollectionUtils.containsAny((Collection)headerList, (Collection)(defaultMediaTypes = ImmutableSet.of((Object)"text/html", (Object)"application/xhtml+xml", (Object)"application/xml")));
        }

        private static Set separateOneLineMediaTypes(List<String> toList) {
            HashSet mediatypes = new HashSet();
            toList.stream().forEach(headerLine -> mediatypes.addAll(Arrays.asList(headerLine.split(",|,\\s"))));
            return mediatypes;
        }

        private class SessionExpiredException
        extends WebApplicationException {
            public SessionExpiredException(String message, SessionErrors error_status, HttpServletRequest optionalRequest) {
                super(message, Factory.buildExceptionResponse(error_status, optionalRequest, message));
            }
        }

        static enum SessionErrors {
            SESSION_INVALIDATED,
            SESSION_AGE_EXCEEDED;

        }
    }
}

