/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;

class JsonBuilderFactoryImpl
implements JsonBuilderFactory,
Serializable {
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private RejectDuplicateKeysMode rejectDuplicateKeysMode;
    private BufferStrategy.BufferProvider<char[]> bufferProvider;
    private static final List<String> SUPPORTED_CONFIG_KEYS = RejectDuplicateKeysMode.CONFIG_KEYS;

    protected JsonBuilderFactoryImpl() {
    }

    JsonBuilderFactoryImpl(Map<String, ?> config, BufferStrategy.BufferProvider<char[]> bufferProvider, RejectDuplicateKeysMode rejectDuplicateKeysMode) {
        this.bufferProvider = bufferProvider;
        this.rejectDuplicateKeysMode = rejectDuplicateKeysMode;
        if (config != null && !config.isEmpty()) {
            for (String configKey : config.keySet()) {
                if (SUPPORTED_CONFIG_KEYS.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(Collections.emptyMap(), this.bufferProvider, this.rejectDuplicateKeysMode);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject initialData) {
        return new JsonObjectBuilderImpl(initialData, this.bufferProvider, this.rejectDuplicateKeysMode);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(Collections.emptyList(), this.bufferProvider, this.rejectDuplicateKeysMode);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        return new JsonArrayBuilderImpl(initialData, this.bufferProvider, this.rejectDuplicateKeysMode);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        return new JsonArrayBuilderImpl(initialData, this.bufferProvider, this.rejectDuplicateKeysMode);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, Object> initialValues) {
        return new JsonObjectBuilderImpl(initialValues, this.bufferProvider, this.rejectDuplicateKeysMode);
    }
}

