/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConstraintViolationException;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectPredicate;
import org.apache.brooklyn.core.objs.ConstraintSerialization;
import org.apache.brooklyn.core.validation.BrooklynValidation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.StringEscapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigConstraints<T> {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigConstraints.class);
    private final T source;

    public static void assertValid(Entity entity) {
        new EntityConfigConstraints(entity).assertValid();
    }

    public static void assertValid(EntityAdjunct adjunct) {
        new EntityAdjunctConstraints(adjunct).assertValid();
    }

    public static <T> void assertValid(Entity entity, ConfigKey<T> key, T value) {
        ConfigConstraints.assertValid(new EntityConfigConstraints(entity), entity, key, value);
    }

    public static <T> void assertValid(EntityAdjunct adj, ConfigKey<T> key, T value) {
        ConfigConstraints.assertValid(new EntityAdjunctConstraints(adj), adj, key, value);
    }

    public static <T> void assertValid(Location location, ConfigKey<T> key, T value) {
        ConfigConstraints.assertValid(new LocationConfigConstraints(location), location, key, value);
    }

    private static <T> void assertValid(ConfigConstraints<?> constrants, Object context, ConfigKey<T> key, T value) {
        try {
            ReferenceWithError<?> validity = constrants.validateValue(key, value);
            if (validity.hasError()) {
                throw validity.getError();
            }
        }
        catch (Throwable e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw ConstraintViolationException.of(e, context, key, value);
        }
    }

    public ConfigConstraints(T source) {
        this.source = source;
    }

    public void assertValid() {
        Map<ConfigKey<?>, Throwable> violations = this.getViolationsDetails();
        if (!violations.isEmpty()) {
            throw ConstraintViolationException.CompoundConstraintViolationException.of(this.getDisplayName(), violations);
        }
    }

    public abstract String getDisplayName();

    public abstract Iterable<ConfigKey<?>> getConfigKeys();

    public abstract Maybe<?> getValue(ConfigKey<?> var1);

    @Nullable
    public abstract ExecutionContext getExecutionContext();

    @Deprecated
    public Iterable<ConfigKey<?>> getViolations() {
        return this.getViolationsDetails().keySet();
    }

    public Map<ConfigKey<?>, Throwable> getViolationsDetails() {
        ExecutionContext exec = this.getExecutionContext();
        if (exec != null) {
            return (Map)exec.get(BrooklynTaskTags.setTransient(Tasks.builder().dynamic(false).displayName("Validating config").body(() -> this.validateAll()).build()));
        }
        return this.validateAll();
    }

    protected Map<ConfigKey<?>, Throwable> validateAll() {
        MutableMap violating = MutableMap.of();
        Iterable<ConfigKey<?>> configKeys = this.getConfigKeys();
        LOG.trace("Checking config keys on {}: {}", this.getSource(), configKeys);
        for (ConfigKey<?> configKey : configKeys) {
            try {
                ReferenceWithError<?> validation;
                Maybe<?> maybeValue = this.getValue(configKey);
                if (!maybeValue.isPresent() || !(validation = this.validateValue(configKey, maybeValue.get())).hasError()) continue;
                violating.put(configKey, validation.getError());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                violating.put(configKey, e);
            }
        }
        return violating;
    }

    <V> boolean isValueValid(ConfigKey<V> configKey, V value) {
        return !this.validateValue(configKey, value).hasError();
    }

    <V> ReferenceWithError<?> validateValue(ConfigKey<V> configKey, V value) {
        Predicate po = null;
        if (value != null && (configKey.getType() == Object.class ? value instanceof Future || value instanceof DeferredSupplier : !configKey.getType().isInstance(value))) {
            return ReferenceWithError.newInstanceWithoutError(null);
        }
        try {
            boolean valid;
            po = configKey.getConstraint();
            if (this.getSource() instanceof BrooklynObject && po instanceof BrooklynObjectPredicate) {
                valid = ((BrooklynObjectPredicate)BrooklynObjectPredicate.class.cast(po)).apply(value, (BrooklynObject)this.getSource());
            } else {
                if (Objects.isNull(value) && !po.toString().contains("required") && !po.toString().contains("Predicates.notNull()")) {
                    return ReferenceWithError.newInstanceWithoutError(null);
                }
                valid = po.apply(value);
            }
            if (!valid) {
                throw new IllegalArgumentException("Constraint '" + po + "' not satisfied");
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return ReferenceWithError.newInstanceThrowingError((Object)po, (Throwable)((Object)ConstraintViolationException.of(e, this.getSource(), configKey, value)));
        }
        try {
            BrooklynValidation.getInstance().validateIfPresent(value);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new IllegalArgumentException("Invalid value for " + configKey.getName() + ": " + value + "; " + Exceptions.collapseText((Throwable)e), e));
        }
        return ReferenceWithError.newInstanceWithoutError(null);
    }

    protected T getSource() {
        return this.source;
    }

    public static ConstraintSerialization serialization() {
        return ConstraintSerialization.INSTANCE;
    }

    public static <T> Predicate<T> required() {
        return new RequiredPredicate();
    }

    public static Predicate<Object> forbiddenIf(String otherKeyName) {
        return new ForbiddenIfPredicate(otherKeyName);
    }

    public static Predicate<Object> forbiddenUnless(String otherKeyName) {
        return new ForbiddenUnlessPredicate(otherKeyName);
    }

    public static Predicate<Object> requiredIf(String otherKeyName) {
        return new RequiredIfPredicate(otherKeyName);
    }

    public static Predicate<Object> requiredUnless(String otherKeyName) {
        return new RequiredUnlessPredicate(otherKeyName);
    }

    public static Predicate<Object> forbiddenUnlessAnyOf(List<String> otherKeyNames) {
        return new ForbiddenUnlessAnyOfPredicate(otherKeyNames);
    }

    public static Predicate<Object> requiredUnlessAnyOf(List<String> otherKeyNames) {
        return new RequiredUnlessAnyOfPredicate(otherKeyNames);
    }

    protected static class RequiredUnlessAnyOfPredicate
    extends OtherKeysPredicate {
        public RequiredUnlessAnyOfPredicate(List<String> otherKeyNames) {
            super(otherKeyNames);
        }

        @Override
        public String predicateName() {
            return "requiredUnlessAnyOf";
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValue) {
            return thisValue != null || otherValue != null && Iterables.tryFind(otherValue, (Predicate)Predicates.notNull()).isPresent();
        }
    }

    protected static class ForbiddenUnlessAnyOfPredicate
    extends OtherKeysPredicate {
        public ForbiddenUnlessAnyOfPredicate(List<String> otherKeyNames) {
            super(otherKeyNames);
        }

        @Override
        public String predicateName() {
            return "forbiddenUnlessAnyOf";
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValue) {
            return thisValue == null || otherValue != null && Iterables.tryFind(otherValue, (Predicate)Predicates.notNull()).isPresent();
        }
    }

    protected static class RequiredUnlessPredicate
    extends OtherKeyPredicate {
        public RequiredUnlessPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "requiredUnless";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue != null || otherValue != null;
        }
    }

    protected static class RequiredIfPredicate
    extends OtherKeyPredicate {
        public RequiredIfPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "requiredIf";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue != null || otherValue == null;
        }
    }

    protected static class ForbiddenUnlessPredicate
    extends OtherKeyPredicate {
        public ForbiddenUnlessPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "forbiddenUnless";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue == null || otherValue != null;
        }
    }

    protected static class ForbiddenIfPredicate
    extends OtherKeyPredicate {
        public ForbiddenIfPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "forbiddenIf";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue == null || otherValue == null;
        }
    }

    private static abstract class OtherKeysPredicate
    implements BrooklynObjectPredicate<Object> {
        private final List<String> otherKeyNames;

        public OtherKeysPredicate(List<String> otherKeyNames) {
            this.otherKeyNames = otherKeyNames;
        }

        public abstract String predicateName();

        public String toString() {
            String params = this.otherKeyNames.stream().map(k -> StringEscapes.JavaStringEscapes.wrapJavaString((String)k)).collect(Collectors.joining(", "));
            return this.predicateName() + "(" + params + ")";
        }

        public boolean apply(Object input) {
            return this.apply(input, (BrooklynObject)BrooklynTaskTags.getContextEntity(Tasks.current()));
        }

        @Override
        public boolean apply(Object input, BrooklynObject context) {
            if (context == null) {
                return true;
            }
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String otherKeyName : this.otherKeyNames) {
                ConfigKey<Object> otherKey = ConfigKeys.newConfigKey(Object.class, otherKeyName);
                BrooklynObjectInternal.ConfigurationSupportInternal configInternal = ((BrooklynObjectInternal)context).config();
                Maybe<Object> maybeValue = configInternal.getNonBlocking(otherKey, false);
                if (maybeValue.isPresent()) {
                    vals.add(maybeValue.get());
                    continue;
                }
                return true;
            }
            return this.test(input, vals);
        }

        public abstract boolean test(Object var1, List<Object> var2);
    }

    private static abstract class OtherKeyPredicate
    extends OtherKeysPredicate {
        public OtherKeyPredicate(String otherKeyName) {
            super((List<String>)ImmutableList.of((Object)otherKeyName));
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValues) {
            return this.test(thisValue, Iterables.getOnlyElement(otherValues));
        }

        public abstract boolean test(Object var1, Object var2);
    }

    public static class RequiredPredicate<T>
    implements Predicate<T> {
        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            return !(input instanceof CharSequence) || ((CharSequence)input).length() != 0;
        }

        public String toString() {
            return "required()";
        }

        public boolean equals(Object obj) {
            return obj instanceof RequiredPredicate && obj.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.toString());
        }
    }

    private static class LocationConfigConstraints
    extends ConfigConstraints<Location> {
        public LocationConfigConstraints(Location brooklynObject) {
            super(brooklynObject);
        }

        @Override
        public String getDisplayName() {
            return ((Location)this.getSource()).getDisplayName();
        }

        @Override
        public Iterable<ConfigKey<?>> getConfigKeys() {
            return Collections.emptyList();
        }

        @Override
        public Maybe<?> getValue(ConfigKey<?> configKey) {
            return ((BrooklynObjectInternal)this.getSource()).config().getNonBlocking(configKey, false);
        }

        @Override
        @Nullable
        public ExecutionContext getExecutionContext() {
            return null;
        }
    }

    private static class EntityAdjunctConstraints
    extends ConfigConstraints<EntityAdjunct> {
        public EntityAdjunctConstraints(EntityAdjunct brooklynObject) {
            super(brooklynObject);
        }

        @Override
        public String getDisplayName() {
            return ((EntityAdjunct)this.getSource()).getDisplayName();
        }

        @Override
        public Iterable<ConfigKey<?>> getConfigKeys() {
            return ((AbstractEntityAdjunct)this.getSource()).getAdjunctType().getConfigKeys();
        }

        @Override
        public Maybe<?> getValue(ConfigKey<?> configKey) {
            return ((BrooklynObjectInternal)this.getSource()).config().getNonBlocking(configKey, false);
        }

        @Override
        @Nullable
        public ExecutionContext getExecutionContext() {
            return this.getSource() instanceof AbstractEntityAdjunct ? ((AbstractEntityAdjunct)this.getSource()).getExecutionContext() : null;
        }
    }

    private static class EntityConfigConstraints
    extends ConfigConstraints<Entity> {
        public EntityConfigConstraints(Entity brooklynObject) {
            super(brooklynObject);
        }

        @Override
        public String getDisplayName() {
            return ((Entity)this.getSource()).getDisplayName();
        }

        @Override
        public Iterable<ConfigKey<?>> getConfigKeys() {
            return ((Entity)this.getSource()).getEntityType().getConfigKeys();
        }

        @Override
        public Maybe<?> getValue(ConfigKey<?> configKey) {
            return ((BrooklynObjectInternal)this.getSource()).config().getNonBlocking(configKey, false);
        }

        @Override
        @Nullable
        public ExecutionContext getExecutionContext() {
            return ((EntityInternal)this.getSource()).getExecutionContext();
        }
    }
}

