/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableSet<V>
extends LinkedHashSet<V> {
    private static final long serialVersionUID = 2330133488446834595L;
    private static final Logger log = LoggerFactory.getLogger(MutableSet.class);

    public static <V> MutableSet<V> of() {
        return new MutableSet<V>();
    }

    public static <V> MutableSet<V> of(V v1) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        return result;
    }

    public static <V> MutableSet<V> of(V v1, V v2) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        result.add(v2);
        return result;
    }

    public static <V> MutableSet<V> of(V v1, V v2, V v3, V ... vMore) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        result.add(v2);
        result.add(v3);
        if (vMore == null) {
            result.add(null);
        } else {
            for (V vi : vMore) {
                result.add(vi);
            }
        }
        return result;
    }

    public static <V> MutableSet<V> copyOf(@Nullable Iterable<? extends V> orig) {
        return orig == null ? new MutableSet<V>() : new MutableSet<V>(orig);
    }

    public static <V> MutableSet<V> copyOf(@Nullable Iterator<? extends V> elements) {
        if (elements == null || !elements.hasNext()) {
            return MutableSet.of();
        }
        return new Builder<V>().addAll(elements).build();
    }

    public MutableSet() {
    }

    public MutableSet(Iterable<? extends V> source) {
        super(source instanceof Collection ? (Collection)source : Sets.newLinkedHashSet(source));
    }

    public Set<V> asImmutableCopy() {
        try {
            return ImmutableSet.copyOf((Collection)this);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            log.warn("Error converting list to Immutable, using unmodifiable instead: " + e, (Throwable)e);
            return this.asUnmodifiableCopy();
        }
    }

    public Set<V> asUnmodifiable() {
        return Collections.unmodifiableSet(this);
    }

    public Set<V> asUnmodifiableCopy() {
        return Collections.unmodifiableSet(MutableSet.copyOf(this));
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public boolean addIfNotNull(V e) {
        if (e != null) {
            return this.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Iterable<? extends V> setToAdd) {
        if (setToAdd == null) {
            return false;
        }
        boolean modified = false;
        Iterator<V> e = setToAdd.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    public MutableSet<V> putAll(Iterable<? extends V> setToAdd) {
        if (setToAdd != null) {
            this.addAll(setToAdd);
        }
        return this;
    }

    public MutableSet<V> put(V e) {
        this.add(e);
        return this;
    }

    public MutableSet<V> putIfNotNull(V e) {
        if (e != null) {
            this.add(e);
        }
        return this;
    }

    public boolean removeIfNotNull(V item) {
        if (item == null) {
            return false;
        }
        return this.remove(item);
    }

    public static class Builder<V> {
        final MutableSet<V> result = new MutableSet();

        public Builder<V> addIfNotNull(V value) {
            if (value != null) {
                this.result.add(value);
            }
            return this;
        }

        public Builder<V> add(V value) {
            this.result.add(value);
            return this;
        }

        public Builder<V> add(V v1, V v2, V ... values) {
            this.result.add(v1);
            this.result.add(v2);
            if (values == null) {
                this.result.add(null);
            } else {
                for (V value : values) {
                    this.result.add(value);
                }
            }
            return this;
        }

        public Builder<V> remove(V val) {
            this.result.remove(val);
            return this;
        }

        public Builder<V> addAll(V[] values) {
            for (V v : values) {
                this.result.add(v);
            }
            return this;
        }

        public Builder<V> addAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                ((AbstractCollection)this.result).addAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.add(v);
                }
            }
            return this;
        }

        public Builder<V> addAll(Iterator<? extends V> iter) {
            while (iter.hasNext()) {
                this.add(iter.next());
            }
            return this;
        }

        public Builder<V> removeAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.removeAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.remove(v);
                }
            }
            return this;
        }

        public Builder<V> retainAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.retainAll((Collection)iterable);
            } else {
                HashSet toretain = Sets.newHashSet(iterable);
                this.result.retainAll(toretain);
            }
            return this;
        }

        public MutableSet<V> build() {
            return new MutableSet<V>(this.result);
        }
    }
}

