/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.TenantIdAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;

public class SecurityGroupInRegion
extends RegionAndName {
    protected final SecurityGroup securityGroup;
    protected final Multimap<TenantIdAndName, SecurityGroup> groupsByName;

    public SecurityGroupInRegion(SecurityGroup securityGroup, String regionId, Iterable<SecurityGroup> allGroupsInRegion) {
        super(regionId, ((SecurityGroup)Preconditions.checkNotNull((Object)securityGroup, (Object)"securityGroup")).getName());
        this.securityGroup = securityGroup;
        this.groupsByName = HashMultimap.create();
        for (SecurityGroup groupInRegion : allGroupsInRegion) {
            TenantIdAndName tenantIdAndName = ((TenantIdAndName.Builder)((TenantIdAndName.Builder)TenantIdAndName.builder().tenantId(groupInRegion.getTenantId())).name(groupInRegion.getName())).build();
            this.groupsByName.put((Object)tenantIdAndName, (Object)groupInRegion);
        }
    }

    public SecurityGroup getSecurityGroup() {
        return this.securityGroup;
    }

    public Map<TenantIdAndName, Collection<SecurityGroup>> getGroupsByName() {
        return this.groupsByName.asMap();
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("securityGroup", (Object)this.securityGroup).add("groupsByName", this.groupsByName);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }
}

