/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Date;

public class Snapshot
implements Comparable<Snapshot> {
    private final String region;
    private final String id;
    private final String volumeId;
    private final int volumeSize;
    private final Status status;
    private final Date startTime;
    private final int progress;
    private final String ownerId;
    private final String description;
    private final String ownerAlias;

    public Snapshot(String region, String id, String volumeId, int volumeSize, Status status, Date startTime, int progress, String ownerId, String description, String ownerAlias) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.id = id;
        this.volumeId = volumeId;
        this.volumeSize = volumeSize;
        this.status = status;
        this.startTime = startTime;
        this.progress = progress;
        this.ownerId = ownerId;
        this.description = description;
        this.ownerAlias = ownerAlias;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getId() {
        return this.id;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public int getVolumeSize() {
        return this.volumeSize;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerAlias() {
        return this.ownerAlias;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ownerAlias == null ? 0 : this.ownerAlias.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + this.progress;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        result = 31 * result + this.volumeSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ownerAlias == null ? other.ownerAlias != null : !this.ownerAlias.equals(other.ownerAlias)) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        if (this.progress != other.progress) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId)) {
            return false;
        }
        return this.volumeSize == other.volumeSize;
    }

    public String toString() {
        return "Snapshot [description=" + this.description + ", id=" + this.id + ", ownerAlias=" + this.ownerAlias + ", ownerId=" + this.ownerId + ", progress=" + this.progress + ", startTime=" + this.startTime + ", status=" + (Object)((Object)this.status) + ", volumeId=" + this.volumeId + ", volumeSize=" + this.volumeSize + "]";
    }

    @Override
    public int compareTo(Snapshot o) {
        return this.startTime.compareTo(o.startTime);
    }

    public static enum Status {
        PENDING,
        COMPLETED,
        ERROR,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(((String)Preconditions.checkNotNull((Object)status, (Object)"status")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

