/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.TenantIdAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;

@Singleton
public class NovaSecurityGroupInRegionToSecurityGroup
implements Function<SecurityGroupInRegion, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public NovaSecurityGroupInRegionToSecurityGroup(Supplier<Map<String, Location>> locationIndex) {
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
    }

    public SecurityGroup apply(final SecurityGroupInRegion groupInRegion) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group = groupInRegion.getSecurityGroup();
        builder.id(group.getId());
        builder.providerId(group.getId());
        builder.ownerId(group.getTenantId());
        builder.name(group.getName());
        if (group.getRules() != null) {
            builder.ipPermissions(Iterables.filter((Iterable)Iterables.transform(group.getRules(), (Function)new Function<SecurityGroupRule, IpPermission>(){

                public IpPermission apply(SecurityGroupRule input) {
                    return NovaSecurityGroupInRegionToSecurityGroup.this.securityGroupRuleToIpPermission(groupInRegion, input);
                }
            }), (Predicate)Predicates.notNull()));
        }
        String regionId = groupInRegion.getRegion();
        Location region = (Location)((Map)this.locationIndex.get()).get(regionId);
        Preconditions.checkState((region != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object[])new Object[]{regionId, this.locationIndex.get()});
        builder.location(region);
        builder.id(regionId + "/" + group.getId());
        return builder.build();
    }

    private IpPermission securityGroupRuleToIpPermission(SecurityGroupInRegion groupInRegion, SecurityGroupRule rule) {
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(rule.getIpProtocol());
        builder.fromPort(rule.getFromPort());
        builder.toPort(rule.getToPort());
        TenantIdAndName ruleGroup = rule.getGroup();
        if (ruleGroup != null) {
            org.jclouds.openstack.nova.v2_0.domain.SecurityGroup owningGroup = groupInRegion.getSecurityGroup();
            Collection<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> referredGroup = groupInRegion.getGroupsByName().get(ruleGroup);
            if (null == referredGroup) {
                this.logger.warn("Unknown group %s used in security rule, refusing to add it to %s (%s)", new Object[]{ruleGroup, owningGroup.getName(), owningGroup.getId()});
                return null;
            }
            if (referredGroup.size() != 1) {
                this.logger.warn("Ambiguous group %s used in security rule, refusing to add it to %s (%s)", new Object[]{ruleGroup, owningGroup.getName(), owningGroup.getId()});
                return null;
            }
            builder.groupId(groupInRegion.getRegion() + "/" + ((org.jclouds.openstack.nova.v2_0.domain.SecurityGroup)Iterables.getOnlyElement(referredGroup)).getId());
        }
        if (rule.getIpRange() != null) {
            builder.cidrBlock(rule.getIpRange());
        }
        return builder.build();
    }
}

