/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Objects;
import java.util.ConcurrentModificationException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSensorEvent<T>
implements SensorEvent<T> {
    private static final Logger log = LoggerFactory.getLogger(BasicSensorEvent.class);
    private final Sensor<T> sensor;
    private final Entity source;
    private final T value;
    private final long timestamp;

    public T getValue() {
        return this.value;
    }

    public Sensor<T> getSensor() {
        return this.sensor;
    }

    public Entity getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BasicSensorEvent(Sensor<T> sensor, Entity source, T value) {
        this(sensor, source, value, System.currentTimeMillis());
    }

    public BasicSensorEvent(Sensor<T> sensor, Entity source, T value, long timestamp) {
        this.sensor = sensor;
        this.source = source;
        this.value = value;
        this.timestamp = timestamp;
    }

    public static <T> SensorEvent<T> of(Sensor<T> sensor, Entity source, T value, long timestamp) {
        return new BasicSensorEvent<T>(sensor, source, value, timestamp);
    }

    public static <T> SensorEvent<T> ofUnchecked(Sensor<T> sensor, Entity source, Object value, long timestamp) {
        return new BasicSensorEvent<Object>(sensor, source, value, timestamp);
    }

    public static <T> SensorEvent<T> of(Sensor<T> sensor, Entity source, T value) {
        return new BasicSensorEvent<T>(sensor, source, value);
    }

    public static <T> SensorEvent<T> ofUnchecked(Sensor<T> sensor, Entity source, Object value) {
        return new BasicSensorEvent<Object>(sensor, source, value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sensor, this.source, this.value});
    }

    public boolean equals(Object o) {
        if (!(o instanceof SensorEvent)) {
            return false;
        }
        SensorEvent other = (SensorEvent)o;
        return Objects.equal(this.sensor, (Object)other.getSensor()) && Objects.equal((Object)this.source, (Object)other.getSource()) && Objects.equal(this.value, (Object)other.getValue());
    }

    public String toString() {
        try {
            return this.source + "." + this.sensor + "=" + this.value + " @ " + this.timestamp;
        }
        catch (ConcurrentModificationException e) {
            String result = this.getClass() + ":" + this.source + "." + this.sensor + "@" + this.timestamp;
            log.warn("Error creating string for " + result + " (ignoring): " + e);
            if (log.isDebugEnabled()) {
                log.debug("Trace for error creating string for " + result + " (ignoring): " + e, (Throwable)e);
            }
            return result;
        }
    }
}

