/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.osgi.BundleMaker;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiArchiveInstaller {
    private static final Logger log = LoggerFactory.getLogger(OsgiArchiveInstaller.class);
    public static final ConfigKey<String> PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX = BrooklynServerConfig.PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX;
    public static final ConfigKey<String> PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX = BrooklynServerConfig.PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX;
    private final OsgiManager osgiManager;
    private ManagedBundle suppliedKnownBundleMetadata;
    private InputStream zipIn;
    private boolean start = true;
    private boolean loadCatalogBom = true;
    private boolean force = false;
    private boolean deferredStart = false;
    private boolean validateTypes = true;
    private File zipFile;
    private boolean isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = false;
    private Manifest discoveredManifest;
    private VersionedName discoveredBomVersionedName;
    OsgiBundleInstallationResult result;
    private ManagedBundle inferredMetadata;
    private final boolean inputStreamSupplied;
    private volatile Predicate<ManagedBundle> blacklistBundlePersistencePredicate;

    OsgiArchiveInstaller(OsgiManager osgiManager, ManagedBundle knownBundleMetadata, InputStream zipIn) {
        this.osgiManager = osgiManager;
        this.suppliedKnownBundleMetadata = knownBundleMetadata;
        this.zipIn = zipIn;
        this.inputStreamSupplied = zipIn != null;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setLoadCatalogBom(boolean loadCatalogBom) {
        this.loadCatalogBom = loadCatalogBom;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDeferredStart(boolean deferredStart) {
        this.deferredStart = deferredStart;
    }

    public void setValidateTypes(boolean validateTypes) {
        this.validateTypes = validateTypes;
    }

    private ManagementContextInternal mgmt() {
        return (ManagementContextInternal)this.osgiManager.getManagementContext();
    }

    private synchronized void init() {
        if (this.result != null) {
            if (this.zipFile != null || this.zipIn == null) {
                return;
            }
            throw new IllegalStateException("This installer instance has already been used and the input stream discarded");
        }
        this.result = new OsgiBundleInstallationResult();
        this.inferredMetadata = this.suppliedKnownBundleMetadata == null ? new BasicManagedBundle() : this.suppliedKnownBundleMetadata;
    }

    private synchronized void makeLocalZipFileFromInputStreamOrUrl() {
        Maybe<Bundle> existingOsgiInstalledBundle = Maybe.absent();
        Maybe existingBrooklynInstalledBundle = Maybe.absent();
        if (this.zipIn == null) {
            if (this.suppliedKnownBundleMetadata != null) {
                if (!this.suppliedKnownBundleMetadata.isNameResolved() && (existingBrooklynInstalledBundle = Maybe.ofDisallowingNull((Object)this.osgiManager.getManagedBundleFromUrl(this.suppliedKnownBundleMetadata.getUrl()))).isPresent()) {
                    ((BasicManagedBundle)this.suppliedKnownBundleMetadata).setSymbolicName(((ManagedBundle)existingBrooklynInstalledBundle.get()).getSymbolicName());
                    ((BasicManagedBundle)this.suppliedKnownBundleMetadata).setVersion(((ManagedBundle)existingBrooklynInstalledBundle.get()).getSuppliedVersionString());
                }
                if (existingOsgiInstalledBundle.isAbsent() && this.suppliedKnownBundleMetadata.getOsgiUniqueUrl() != null) {
                    existingOsgiInstalledBundle = Osgis.bundleFinder(this.osgiManager.framework).requiringFromUrl(this.suppliedKnownBundleMetadata.getOsgiUniqueUrl()).find();
                }
                if (existingOsgiInstalledBundle.isAbsent() && this.suppliedKnownBundleMetadata.getUrl() != null) {
                    existingOsgiInstalledBundle = Osgis.bundleFinder(this.osgiManager.framework).requiringFromUrl(this.suppliedKnownBundleMetadata.getUrl()).find();
                }
                if (existingOsgiInstalledBundle.isAbsent() && this.suppliedKnownBundleMetadata.isNameResolved()) {
                    existingOsgiInstalledBundle = Osgis.bundleFinder(this.osgiManager.framework).symbolicName(this.suppliedKnownBundleMetadata.getSymbolicName()).version(this.suppliedKnownBundleMetadata.getSuppliedVersionString()).find();
                }
                if (existingOsgiInstalledBundle.isPresent()) {
                    if (existingBrooklynInstalledBundle.isAbsent()) {
                        existingBrooklynInstalledBundle = Maybe.ofDisallowingNull((Object)this.osgiManager.getManagedBundle(new VersionedName((Bundle)existingOsgiInstalledBundle.get())));
                    }
                    if (this.suppliedKnownBundleMetadata.getUrl() == null) {
                        if (existingBrooklynInstalledBundle.isPresent()) {
                            log.debug("Detected bundle " + this.suppliedKnownBundleMetadata + " installed to Brooklyn already; no URL or stream supplied, so re-using existing installation");
                            this.result.metadata = (ManagedBundle)existingBrooklynInstalledBundle.get();
                            this.result.setIgnoringAlreadyInstalled();
                            return;
                        }
                        String candidateUrl = ((Bundle)existingOsgiInstalledBundle.get()).getLocation();
                        log.debug("Detected bundle " + this.suppliedKnownBundleMetadata + " installed to OSGi but not Brooklyn; trying to find a URL to get bundle binary, candidate " + candidateUrl);
                        if (Strings.isBlank((CharSequence)candidateUrl)) {
                            throw new IllegalArgumentException("No input stream available and no URL could be found: no way to promote " + this.suppliedKnownBundleMetadata + " from " + existingOsgiInstalledBundle.get() + " to Brooklyn management");
                        }
                        try {
                            this.zipIn = ResourceUtils.create(this.mgmt()).getResourceFromUrl(candidateUrl);
                            this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = true;
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            throw new IllegalArgumentException("Could not find binary for already installed OSGi bundle " + existingOsgiInstalledBundle.get() + " (location " + candidateUrl + ") when trying to promote " + this.suppliedKnownBundleMetadata + " to Brooklyn management", e);
                        }
                    }
                } else if (this.suppliedKnownBundleMetadata.getUrl() == null) {
                    throw new IllegalArgumentException("No input stream available and no URL could be found: no way to install " + this.suppliedKnownBundleMetadata);
                }
                assert (this.zipIn != null || this.suppliedKnownBundleMetadata.getUrl() != null) : "should have found a stream or inferred a URL";
                if (this.zipIn == null) {
                    if (existingBrooklynInstalledBundle.isAbsent() || this.force) {
                        String url = this.suppliedKnownBundleMetadata.getUrl();
                        if (BrooklynVersion.isDevelopmentEnvironment() && url.startsWith("system:file:")) {
                            try {
                                url = Strings.removeFromStart((String)url, (String)"system:");
                                File zipTemp = new BundleMaker(ResourceUtils.create()).createJarFromClasspathDir(url);
                                this.zipIn = new FileInputStream(zipTemp);
                            }
                            catch (FileNotFoundException e) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                        } else {
                            this.zipIn = ResourceUtils.create(this.mgmt()).getResourceFromUrl(url, this.suppliedKnownBundleMetadata.getUrlCredential());
                        }
                    } else {
                        this.result.metadata = (ManagedBundle)existingBrooklynInstalledBundle.get();
                        this.result.setIgnoringAlreadyInstalled();
                        return;
                    }
                }
            }
            this.result.bundle = (Bundle)existingOsgiInstalledBundle.orNull();
        }
        this.zipFile = Os.newTempFile((String)("brooklyn-bundle-transient-" + this.suppliedKnownBundleMetadata), (String)"zip");
        try {
            FileOutputStream fos = new FileOutputStream(this.zipFile);
            Streams.copyClose((InputStream)this.zipIn, (OutputStream)fos);
            try (ZipFile zf = new ZipFile(this.zipFile);){
                zf.entries();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            Streams.closeQuietly((Closeable)this.zipIn);
            this.zipIn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverManifestFromCatalogBom(boolean isCatalogBomRequired) {
        String bomS;
        ZipEntry bom;
        ZipFile zf;
        block8: {
            block9: {
                this.discoveredManifest = new BundleMaker(this.mgmt()).getManifest(this.zipFile);
                zf = null;
                try {
                    try {
                        zf = new ZipFile(this.zipFile);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid ZIP/JAR archive: " + e);
                    }
                    bom = zf.getEntry("catalog.bom");
                    if (bom == null) {
                        bom = zf.getEntry("/catalog.bom");
                    }
                    if (bom != null) break block8;
                    if (!isCatalogBomRequired) break block9;
                    throw new IllegalArgumentException("Archive must contain a catalog.bom file in the root");
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly(zf);
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)zf);
            return;
        }
        try {
            bomS = Streams.readFullyString((InputStream)zf.getInputStream(bom));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading catalog.bom from ZIP/JAR archive: " + e);
        }
        this.discoveredBomVersionedName = BasicBrooklynCatalog.getVersionedName(BasicBrooklynCatalog.getCatalogMetadata(bomS), false);
        Streams.closeQuietly((Closeable)zf);
    }

    private void updateManifestFromAllSourceInformation() {
        if (this.discoveredBomVersionedName != null) {
            this.matchSetOrFail("catalog.bom in archive", this.discoveredBomVersionedName.getSymbolicName(), this.discoveredBomVersionedName.getVersionString());
        }
        boolean manifestNeedsUpdating = false;
        if (this.discoveredManifest == null) {
            this.discoveredManifest = new Manifest();
            manifestNeedsUpdating = true;
        }
        if (!this.matchSetOrFail("MANIFEST.MF in archive", this.discoveredManifest.getMainAttributes().getValue("Bundle-SymbolicName"), this.discoveredManifest.getMainAttributes().getValue("Bundle-Version"))) {
            manifestNeedsUpdating = true;
            this.discoveredManifest.getMainAttributes().putValue("Bundle-SymbolicName", this.inferredMetadata.getSymbolicName());
            this.discoveredManifest.getMainAttributes().putValue("Bundle-Version", this.inferredMetadata.getOsgiVersionString());
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            throw new IllegalArgumentException("Missing bundle symbolic name in BOM or MANIFEST");
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            throw new IllegalArgumentException("Missing bundle version in BOM or MANIFEST");
        }
        if (this.discoveredManifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            this.discoveredManifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            manifestNeedsUpdating = true;
        }
        if (manifestNeedsUpdating) {
            File zf2 = new BundleMaker(this.mgmt()).copyAddingManifest(this.zipFile, this.discoveredManifest);
            this.zipFile.delete();
            this.zipFile = zf2;
        }
    }

    private synchronized void close() {
        if (this.zipFile != null) {
            this.zipFile.delete();
            this.zipFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReferenceWithError<OsgiBundleInstallationResult> install() {
        boolean startedInstallation = false;
        try {
            File oldZipFile;
            boolean updating;
            block69: {
                List<Bundle> existingBundles;
                block68: {
                    Maybe<VersionedName> forcedReplacementBundle;
                    block70: {
                        String knownIdForThisUrl;
                        ReferenceWithError inferredName;
                        this.init();
                        if (this.suppliedKnownBundleMetadata != null) {
                            if (this.suppliedKnownBundleMetadata.isNameResolved()) {
                                Maybe<VersionedName> forcedReplacementBundle2 = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(this.mgmt(), this.suppliedKnownBundleMetadata.getVersionedName());
                                if (forcedReplacementBundle2.isPresent()) {
                                    ReferenceWithError<OsgiBundleInstallationResult> referenceWithError = this.generateForciblyRemovedResult(this.suppliedKnownBundleMetadata.getVersionedName(), forcedReplacementBundle2);
                                    return referenceWithError;
                                }
                            } else if (this.suppliedKnownBundleMetadata.getUrl() != null && this.suppliedKnownBundleMetadata.getUrl().toLowerCase().startsWith("mvn:") && (inferredName = OsgiArchiveInstaller.inferBundleNameFromMvnUrl(this.suppliedKnownBundleMetadata.getUrl())).isPresent() && (forcedReplacementBundle = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(this.mgmt(), (VersionedName)inferredName.get())).isPresent()) {
                                ReferenceWithError<OsgiBundleInstallationResult> referenceWithError = this.generateForciblyRemovedResult((VersionedName)inferredName.get(), forcedReplacementBundle);
                                return referenceWithError;
                            }
                        }
                        this.makeLocalZipFileFromInputStreamOrUrl();
                        if (this.result.code != null) {
                            inferredName = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                            return inferredName;
                        }
                        this.discoverManifestFromCatalogBom(false);
                        if (this.result.code != null) {
                            inferredName = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                            return inferredName;
                        }
                        this.updateManifestFromAllSourceInformation();
                        if (this.result.code != null) {
                            inferredName = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                            return inferredName;
                        }
                        assert (this.inferredMetadata.isNameResolved()) : "Should have resolved " + this.inferredMetadata;
                        assert (this.inferredMetadata instanceof BasicManagedBundle) : "Only BasicManagedBundles supported";
                        ((BasicManagedBundle)this.inferredMetadata).setChecksum(OsgiArchiveInstaller.getChecksum(new ZipFile(this.zipFile)));
                        this.result.metadata = this.osgiManager.getManagedBundle(this.inferredMetadata.getVersionedName());
                        if (this.result.getMetadata() == null) break block70;
                        if (this.suppliedKnownBundleMetadata != null && this.suppliedKnownBundleMetadata.getUrl() != null) {
                            knownIdForThisUrl = this.osgiManager.managedBundlesRecord.getManagedBundleIdFromUrl(this.suppliedKnownBundleMetadata.getUrl());
                            if (knownIdForThisUrl == null) {
                                log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is not recognized but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                                this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                            } else if (!knownIdForThisUrl.equals(this.result.getMetadata().getId())) {
                                log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is associated to " + knownIdForThisUrl + " but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                                this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                            }
                        }
                        this.result.bundle = this.osgiManager.framework.getBundleContext().getBundle(this.result.getMetadata().getOsgiUniqueUrl());
                        if (this.result.bundle != null && OsgiArchiveInstaller.checksumsMatch(this.result.getMetadata(), this.inferredMetadata)) {
                            log.trace("Bundle " + this.inferredMetadata + " matches already installed managed bundle " + this.result.getMetadata() + "; install is no-op");
                            this.result.setIgnoringAlreadyInstalled();
                            knownIdForThisUrl = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                            return knownIdForThisUrl;
                        }
                        if (OsgiArchiveInstaller.isEquivalentBundleAlreadyOsgiInstalled(this.osgiManager, this.inferredMetadata, this.zipFile)) {
                            log.trace("Bundle " + this.inferredMetadata + " matches metadata of managed bundle " + this.result.getMetadata() + " (but not OSGi bundle location " + this.result.getMetadata().getOsgiUniqueUrl() + "), and matches already installed OSGi bundle; ; install is no-op");
                            this.result.setIgnoringAlreadyInstalled();
                            knownIdForThisUrl = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                            return knownIdForThisUrl;
                        }
                        if (this.canUpdate()) {
                            if (this.result.getBundle() == null) {
                                log.warn("Brooklyn thought it was already managing bundle " + this.result.getMetadata().getVersionedName() + " but it's not installed to framework at location " + this.result.getMetadata().getOsgiUniqueUrl() + "; reinstalling it");
                                updating = false;
                                break block68;
                            } else {
                                log.trace("Updating existing brooklyn-managed bundle " + this.result);
                                updating = true;
                            }
                            break block68;
                        } else {
                            List<Bundle> existingBundles2 = OsgiArchiveInstaller.findBundlesByVersion(this.osgiManager, this.inferredMetadata);
                            if (existingBundles2.size() > 0 && (this.result.getMetadata().getChecksum() == null || this.inferredMetadata.getChecksum() == null)) {
                                log.info("Missing bundle checksum data for " + this.result + "; assuming bundle matches existing brooklyn-managed bundle (not re-installing)");
                                this.result.setIgnoringAlreadyInstalled();
                                ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                                return referenceWithError;
                            }
                            if (this.result.bundle != null) throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already installed; cannot install a different bundle with the same non-snapshot version");
                            if (existingBundles2.size() <= 0) throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already a brooklyn-managed bundle, but not found in OSGi framework; will not re-install without use of 'force'");
                            throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already installed; cannot install a different bundle with the same non-snapshot version");
                        }
                    }
                    forcedReplacementBundle = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(this.mgmt(), this.inferredMetadata.getVersionedName());
                    if (forcedReplacementBundle.isPresent()) {
                        ReferenceWithError<OsgiBundleInstallationResult> referenceWithError = this.generateForciblyRemovedResult(this.inferredMetadata.getVersionedName(), forcedReplacementBundle);
                        return referenceWithError;
                    }
                    this.result.metadata = this.inferredMetadata;
                    existingBundles = OsgiArchiveInstaller.findBundlesByVersion(this.osgiManager, this.inferredMetadata);
                    Maybe<Bundle> existingEquivalentBundle = OsgiArchiveInstaller.tryFindEquivalentBundle(existingBundles, this.inferredMetadata, this.zipFile);
                    if (existingEquivalentBundle.isPresent()) {
                        this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = true;
                        this.result.bundle = (Bundle)existingEquivalentBundle.get();
                    } else if (existingBundles.size() > 0) {
                        Bundle existingBundle = existingBundles.get(0);
                        if (this.force && this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                            log.debug("Request to install " + this.inferredMetadata + " was forced, so forcing reinstallation of existing OSGi installed (but not Brooklyn-managed) bundle " + existingBundle);
                            this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = false;
                        }
                        if (this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                            this.result.bundle = existingBundle;
                        } else {
                            log.debug("Brooklyn install of " + this.result.getMetadata().getVersionedName() + " detected already loaded in OSGi; uninstalling that to reinstall as Brooklyn-managed");
                            existingBundle.uninstall();
                            this.result.bundle = null;
                        }
                    }
                    updating = false;
                }
                startedInstallation = true;
                FileInputStream fin = new FileInputStream(this.zipFile);
                existingBundles = null;
                try {
                    if (!updating) {
                        if (this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                            assert (this.result.getBundle() != null);
                            log.debug("Brooklyn install of " + this.result.getMetadata().getVersionedName() + " detected already loaded " + this.result.getBundle() + " in OSGi can be re-used, skipping OSGi install");
                            break block69;
                        } else {
                            assert (this.result.getBundle() == null);
                            log.debug("Installing bundle " + this.result.getMetadata().getVersionedName() + ", using OSGi location " + this.result.getMetadata().getOsgiUniqueUrl());
                            this.result.bundle = this.osgiManager.framework.getBundleContext().installBundle(this.result.getMetadata().getOsgiUniqueUrl(), (InputStream)fin);
                        }
                        break block69;
                    }
                    this.result.bundle.update((InputStream)fin);
                }
                catch (Throwable existingEquivalentBundle) {
                    existingBundles = existingEquivalentBundle;
                    throw existingEquivalentBundle;
                }
                finally {
                    if (fin != null) {
                        if (existingBundles != null) {
                            try {
                                ((InputStream)fin).close();
                            }
                            catch (Throwable existingEquivalentBundle) {
                                ((Throwable)((Object)existingBundles)).addSuppressed(existingEquivalentBundle);
                            }
                        } else {
                            ((InputStream)fin).close();
                        }
                    }
                }
            }
            this.osgiManager.checkCorrectlyInstalled((OsgiBundleWithUrl)this.result.getMetadata(), this.result.bundle);
            if (!updating) {
                oldZipFile = null;
                this.osgiManager.managedBundlesRecord.addManagedBundle(this.result, this.zipFile);
                this.result.code = OsgiBundleInstallationResult.ResultCode.INSTALLED_NEW_BUNDLE;
                this.result.message = "Installed Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " with ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
                if (!this.isBlacklistedForPersistence(this.result.getMetadata())) {
                    ((BasicManagedBundle)this.result.getMetadata()).setPersistenceNeeded(true);
                    this.mgmt().getRebindManager().getChangeListener().onManaged((BrooklynObject)this.result.getMetadata());
                }
            } else {
                oldZipFile = this.osgiManager.managedBundlesRecord.updateManagedBundleFile(this.result, this.zipFile);
                this.result.code = OsgiBundleInstallationResult.ResultCode.UPDATED_EXISTING_BUNDLE;
                this.result.message = "Updated Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " as existing ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
                if (!this.isBlacklistedForPersistence(this.result.getMetadata())) {
                    ((BasicManagedBundle)this.result.getMetadata()).setPersistenceNeeded(true);
                    this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)this.result.getMetadata());
                }
            }
            log.debug(this.result.message + " (partial): OSGi bundle installed, with bundle start and Brooklyn management to follow");
            this.zipFile.delete();
            this.zipFile = null;
            Runnable startRunnable = new Runnable(){

                private void rollbackBundle() {
                    if (updating) {
                        if (oldZipFile == null) {
                            throw new IllegalStateException("Did not have old ZIP file to install");
                        }
                        log.debug("Rolling back bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + " to state from " + oldZipFile);
                        try {
                            File zipFileNow = ((OsgiArchiveInstaller)OsgiArchiveInstaller.this).osgiManager.managedBundlesRecord.rollbackManagedBundleFile(OsgiArchiveInstaller.this.result, oldZipFile);
                            OsgiArchiveInstaller.this.result.bundle.update((InputStream)new FileInputStream((File)Preconditions.checkNotNull((Object)zipFileNow, (Object)"Couldn't find contents of old version of bundle")));
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            log.error("Error rolling back following failed install of updated " + OsgiArchiveInstaller.this.result.getVersionedName() + "; installation will likely be corrupted and correct version should be manually installed.", (Throwable)e);
                        }
                        if (!OsgiArchiveInstaller.this.isBlacklistedForPersistence(OsgiArchiveInstaller.this.result.getMetadata())) {
                            ((BasicManagedBundle)OsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                            OsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)OsgiArchiveInstaller.this.result.getMetadata());
                        }
                    } else {
                        if (OsgiArchiveInstaller.this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                            log.debug("Uninstalling bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + " from Brooklyn management only (rollback needed but it was already installed to OSGi)");
                        } else {
                            log.debug("Uninstalling bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + " (roll back of failed fresh install, no previous version to revert to)");
                        }
                        OsgiArchiveInstaller.this.osgiManager.uninstallUploadedBundle(OsgiArchiveInstaller.this.result.getMetadata(), false, OsgiArchiveInstaller.this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement);
                        if (!OsgiArchiveInstaller.this.isBlacklistedForPersistence(OsgiArchiveInstaller.this.result.getMetadata())) {
                            ((BasicManagedBundle)OsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                            OsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)OsgiArchiveInstaller.this.result.getMetadata());
                        }
                    }
                }

                @Override
                public void run() {
                    if (OsgiArchiveInstaller.this.start) {
                        try {
                            log.debug("Starting bundle " + OsgiArchiveInstaller.this.result.getVersionedName());
                            OsgiArchiveInstaller.this.result.bundle.start();
                        }
                        catch (BundleException e) {
                            log.warn("Error starting bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle, then re-throwing error: " + (Object)((Object)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + OsgiArchiveInstaller.this.result.getVersionedName() + " after bundle start problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure installing and rolling back; server may be in inconsistent state regarding bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                    if (OsgiArchiveInstaller.this.loadCatalogBom) {
                        Iterable<RegisteredType> itemsFromOldBundle = null;
                        MutableMap itemsReplacedHere = null;
                        try {
                            if (updating) {
                                itemsFromOldBundle = OsgiArchiveInstaller.this.osgiManager.uninstallCatalogItemsFromBundle(OsgiArchiveInstaller.this.result.getVersionedName());
                            }
                            itemsReplacedHere = MutableMap.of();
                            OsgiArchiveInstaller.this.osgiManager.loadCatalogBom(OsgiArchiveInstaller.this.result.bundle, OsgiArchiveInstaller.this.force, OsgiArchiveInstaller.this.validateTypes, (Map<RegisteredType, RegisteredType>)itemsReplacedHere);
                            Iterable items = OsgiArchiveInstaller.this.mgmt().getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle((OsgiBundleWithUrl)OsgiArchiveInstaller.this.result.getMetadata()));
                            log.debug("Adding items from bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ": " + items);
                            for (RegisteredType ci : items) {
                                OsgiArchiveInstaller.this.result.addType(ci);
                            }
                        }
                        catch (Exception e) {
                            if (CatalogInitialization.isRebindReadOnlyShuttingDown(((OsgiArchiveInstaller)OsgiArchiveInstaller.this).osgiManager.mgmt)) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                            log.warn("Error adding Brooklyn items from bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle and items, then re-throwing error: " + Exceptions.collapseText((Throwable)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + OsgiArchiveInstaller.this.result.getVersionedName() + " after catalog install problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure loading catalog items, and also failed rolling back; server may be in inconsistent state regarding bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            if (itemsFromOldBundle != null) {
                                for (RegisteredType oldItem : itemsFromOldBundle) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced bundle item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)OsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            if (itemsReplacedHere != null) {
                                MutableList replaced = MutableList.copyOf(itemsReplacedHere.values());
                                Collections.reverse(replaced);
                                for (RegisteredType oldItem : replaced) {
                                    if (oldItem == null) continue;
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced external item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)OsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                }
            };
            if (this.deferredStart) {
                this.result.deferredStart = startRunnable;
                log.debug(this.result.message + " (Brooklyn load deferred)");
            } else {
                startRunnable.run();
                if (!this.result.typesInstalled.isEmpty()) {
                    int MAX_TO_LIST_EXPLICITLY = 5;
                    Iterable firstN = Iterables.transform((Iterable)MutableList.copyOf((Iterable)Iterables.limit(this.result.typesInstalled, (int)5)), (Function)new Function<RegisteredType, String>(){

                        public String apply(RegisteredType input) {
                            return input.getVersionedName().toString();
                        }
                    });
                    log.info(this.result.message + ", items: " + firstN + (this.result.typesInstalled.size() > 5 ? " (and others, " + this.result.typesInstalled.size() + " total)" : ""));
                    if (log.isDebugEnabled() && this.result.typesInstalled.size() > 5) {
                        log.debug(this.result.message + ", all items: " + this.result.typesInstalled);
                    }
                } else {
                    log.debug(this.result.message + " (complete): bundle started and now managed by Brooklyn, though no catalog items found (may have installed other bundles though)");
                }
            }
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
            return referenceWithError;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            this.result.code = startedInstallation ? OsgiBundleInstallationResult.ResultCode.ERROR_LAUNCHING_BUNDLE : OsgiBundleInstallationResult.ResultCode.ERROR_PREPARING_BUNDLE;
            this.result.message = "Bundle " + this.inferredMetadata + " failed " + (startedInstallation ? "installation" : "preparation") + ": " + Exceptions.collapseText((Throwable)e);
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceThrowingError((Object)this.result, (Throwable)new IllegalStateException(this.result.message, e));
            return referenceWithError;
        }
        finally {
            this.close();
        }
    }

    @VisibleForTesting
    static Optional<VersionedName> inferBundleNameFromMvnUrl(String url) {
        assert (url.startsWith("mvn:")) : "url=" + url;
        String[] parts = url.substring(4).split("/");
        if (parts.length != 3) {
            return Optional.absent();
        }
        if (parts[0].trim().isEmpty() || parts[1].trim().isEmpty() || parts[2].trim().isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new VersionedName(parts[0] + "." + parts[1], parts[2]));
    }

    private ReferenceWithError<OsgiBundleInstallationResult> generateForciblyRemovedResult(VersionedName desiredBundle, Maybe<VersionedName> replacementBundle) {
        if (replacementBundle.isPresentAndNonNull()) {
            this.result.metadata = this.osgiManager.getManagedBundle((VersionedName)replacementBundle.get());
            if (this.result.getMetadata() != null) {
                this.result.bundle = this.osgiManager.framework.getBundleContext().getBundle(this.result.getMetadata().getOsgiUniqueUrl());
                log.debug("Bundle " + this.inferredMetadata + " forcibly replaced by bundle " + this.result.getMetadata() + "; install is no-op");
                this.result.setIgnoringForciblyRemoved(this.inferredMetadata.getVersionedName(), replacementBundle);
                return ReferenceWithError.newInstanceWithoutError((Object)this.result);
            }
            throw new IllegalArgumentException("Bundle " + this.inferredMetadata + " forcibly replaced by bundle " + replacementBundle.get() + ", but replacement not found");
        }
        log.debug("Bundle " + this.inferredMetadata + " forcibly removed, but no upgrade bundle supplied; install is no-op");
        this.result.setIgnoringForciblyRemoved(this.inferredMetadata.getVersionedName(), (Maybe<VersionedName>)Maybe.absent());
        return ReferenceWithError.newInstanceWithoutError((Object)this.result);
    }

    @VisibleForTesting
    boolean isBlacklistedForPersistence(ManagedBundle managedBundle) {
        if (this.blacklistBundlePersistencePredicate == null) {
            String whitelistRegex = (String)this.mgmt().getConfig().getConfig(PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX);
            String blacklistRegex = (String)this.mgmt().getConfig().getConfig(PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX);
            final Pattern whitelistPattern = whitelistRegex != null ? Pattern.compile(whitelistRegex) : null;
            final Pattern blacklistPattern = blacklistRegex != null ? Pattern.compile(blacklistRegex) : null;
            this.blacklistBundlePersistencePredicate = new Predicate<ManagedBundle>(){

                public boolean apply(ManagedBundle input) {
                    String bundleName = input.getSymbolicName();
                    if (whitelistPattern != null && whitelistPattern.matcher(bundleName).matches()) {
                        return false;
                    }
                    return blacklistPattern != null && blacklistPattern.matcher(bundleName).matches();
                }
            };
        }
        return this.blacklistBundlePersistencePredicate.apply((Object)managedBundle);
    }

    private static List<Bundle> findBundlesByVersion(OsgiManager osgiManager, ManagedBundle desired) {
        return Osgis.bundleFinder(osgiManager.framework).symbolicName(desired.getSymbolicName()).version(desired.getOsgiVersionString()).findAll();
    }

    private static boolean checksumsMatch(ManagedBundle actual, ManagedBundle desired) {
        return actual.getChecksum() != null && Objects.equal((Object)actual.getChecksum(), (Object)desired.getChecksum());
    }

    private static boolean isEquivalentBundleAlreadyOsgiInstalled(OsgiManager osgiManager, ManagedBundle desired, File zipFile) {
        for (Bundle bundle : OsgiArchiveInstaller.findBundlesByVersion(osgiManager, desired)) {
            if (!OsgiArchiveInstaller.isEquivalentBundle(bundle, desired, zipFile)) continue;
            return true;
        }
        return false;
    }

    private static Maybe<Bundle> tryFindEquivalentBundle(Iterable<? extends Bundle> bundles, ManagedBundle desired, File zipFile) {
        for (Bundle bundle : bundles) {
            if (!OsgiArchiveInstaller.isEquivalentBundle(bundle, desired, zipFile)) continue;
            return Maybe.of((Object)bundle);
        }
        return Maybe.absent();
    }

    private static boolean isEquivalentBundle(Bundle bundle, ManagedBundle desired, File zipFile) {
        if (Objects.equal((Object)bundle.getLocation(), (Object)desired.getUrl())) {
            log.debug("Request to install " + desired + " from same location " + bundle.getLocation() + " as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so skipping reinstall");
            return true;
        }
        try {
            if (Streams.compare((InputStream)new FileInputStream(zipFile), (InputStream)new URL(bundle.getLocation()).openStream())) {
                log.debug("Request to install " + desired + " has same contents as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so skipping reinstall");
                return true;
            }
            log.debug("Request to install " + desired + " has different contents as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so will do reinstall (if no other equivalents found)");
            return false;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.debug("Request to install " + desired + " could not compare contents with existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so will do reinstall if not other equivalents found (error " + e + " loading from " + bundle.getLocation() + ")");
            return false;
        }
    }

    private static String getChecksum(ZipFile zf) {
        try {
            MutableMap entriesToChecksum = MutableMap.of();
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                entriesToChecksum.put(zipEntry.getName(), Streams.getMd5Checksum((InputStream)zf.getInputStream(zipEntry)));
            }
            return Streams.getMd5Checksum((InputStream)Streams.newInputStreamWithContents((String)new TreeMap(entriesToChecksum).toString()));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private boolean canUpdate() {
        return this.force || VersionComparator.isSnapshot((String)this.inferredMetadata.getSuppliedVersionString()) && this.inputStreamSupplied;
    }

    private boolean matchSetOrFail(String source, String name, String version) {
        boolean suppliedIsComplete = true;
        if (Strings.isBlank((CharSequence)name)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            ((BasicManagedBundle)this.inferredMetadata).setSymbolicName(name);
        } else if (!Objects.equal((Object)this.inferredMetadata.getSymbolicName(), (Object)name)) {
            throw new IllegalArgumentException("Symbolic name mismatch '" + name + "' from " + source + " (expected '" + this.inferredMetadata.getSymbolicName() + "')");
        }
        if (Strings.isBlank((CharSequence)version)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            ((BasicManagedBundle)this.inferredMetadata).setVersion(version);
        } else if (!BrooklynVersionSyntax.equalAsOsgiVersions((String)this.inferredMetadata.getSuppliedVersionString(), (String)version)) {
            throw new IllegalArgumentException("Bundle version mismatch '" + version + "' from " + source + " (expected '" + this.inferredMetadata.getSuppliedVersionString() + "')");
        }
        return suppliedIsComplete;
    }
}

