/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.activemq;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQBrokerImpl;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQQueue;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQTopic;
import org.apache.brooklyn.entity.messaging.jms.JMSBroker;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="ActiveMQ Broker", description="ActiveMQ is an open source message broker which fully implements the Java Message Service 1.1 (JMS)", iconUrl="classpath:///activemq-logo.png")
@ImplementedBy(value=ActiveMQBrokerImpl.class)
public interface ActiveMQBroker
extends SoftwareProcess,
MessageBroker,
UsesJmx,
JMSBroker<ActiveMQQueue, ActiveMQTopic> {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = SoftwareProcess.START_TIMEOUT;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"5.10.2");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"apache-activemq-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "${driver.mirrorUrl}/${version}/apache-activemq-${version}-bin.tar.gz");
    @SetFromFlag(value="mirrorUrl")
    public static final BasicConfigKey<String> MIRROR_URL = new BasicConfigKey(String.class, "activemq.install.mirror.url", "URL of mirror", (Object)"http://www.mirrorservice.org/sites/ftp.apache.org/activemq");
    @SetFromFlag(value="brokerName")
    public static final AttributeSensorAndConfigKey<String, String> BROKER_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"activemq.brokerName", (String)"ActiveMQ Broker Name", (String)"localhost");
    @SetFromFlag(value="openWirePort")
    public static final PortAttributeSensorAndConfigKey OPEN_WIRE_PORT = new PortAttributeSensorAndConfigKey("openwire.port", "OpenWire port", (Object)"61616+");
    @SetFromFlag(value="jettyPort")
    public static final PortAttributeSensorAndConfigKey AMQ_JETTY_PORT = new PortAttributeSensorAndConfigKey("activemq.jetty.port", "jetty port", (Object)"8161+");
    @SetFromFlag(value="jmxUser")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_USER = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_USER, (Object)"admin");
    @SetFromFlag(value="jmxPassword")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_PASSWORD = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_PASSWORD, (Object)"admin");
    @SetFromFlag(value="templateConfigurationUrl")
    public static final BasicAttributeSensorAndConfigKey<String> TEMPLATE_CONFIGURATION_URL = new BasicAttributeSensorAndConfigKey(String.class, "activemq.templateConfigurationUrl", "Template file (in freemarker format) for the conf/activemq.xml file", (Object)"classpath://org/apache/brooklyn/entity/messaging/activemq/activemq.xml");
}

