/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.location.Provider;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;

@Singleton
public class AtmosBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private final Function<Invocation, HttpRequest> processor;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;
    private final SignRequest signer;
    private final URI endpoint;
    private final String identity;
    private final DateService dateService;
    private final com.google.inject.Provider<String> timeStampProvider;

    @Inject
    public AtmosBlobRequestSigner(Function<Invocation, HttpRequest> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2ObjectGetOptions, SignRequest signer, @Provider Supplier<URI> endpointProvider, @Provider Supplier<Credentials> creds, DateService dateService, @TimeStamp com.google.inject.Provider<String> timeStampProvider) throws SecurityException, NoSuchMethodException {
        this.processor = (Function)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.getMethod = Reflection2.method(AtmosClient.class, (String)"readFile", (Class[])new Class[]{String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(AtmosClient.class, (String)"deletePath", (Class[])new Class[]{String.class});
        this.createMethod = Reflection2.method(AtmosClient.class, (String)"createFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
        this.signer = signer;
        this.endpoint = (URI)endpointProvider.get();
        this.identity = ((Credentials)creds.get()).identity;
        this.dateService = dateService;
        this.timeStampProvider = timeStampProvider;
    }

    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("GET", "/rest/namespace/" + container + "/" + name, timeInSeconds);
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))))));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.deleteMethod, (List)ImmutableList.of((Object)this.getPath(container, name))))));
    }

    private String getPath(String container, String name) {
        return (String)Preconditions.checkNotNull((Object)container, (Object)"container") + "/" + (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)this.getPath(container, name), (Object)this.blob2ObjectGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")))))));
    }

    private HttpRequest sign(String method, String path, long timeInSeconds) {
        Date now = this.dateService.rfc1123DateParse((String)this.timeStampProvider.get());
        String expires = String.valueOf(now.getTime() / 1000L + timeInSeconds);
        String stringToSign = method + "\n" + path + "\n" + this.identity + "\n" + expires;
        return HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((CharSequence)(this.endpoint.getScheme() + "://" + this.endpoint.getHost())).appendPath(path).build()).addQueryParam("uid", new String[]{this.identity}).addQueryParam("expires", new String[]{expires}).addQueryParam("signature", new String[]{this.signer.calculateSignature(stringToSign)}).build();
    }
}

