/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.BrooklynVersionService;
import org.apache.brooklyn.core.mgmt.classloading.OsgiBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.rt.felix.ManifestHelper;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.OsgiUtil;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynVersion
implements BrooklynVersionService {
    private static final Logger log = LoggerFactory.getLogger(BrooklynVersion.class);
    private static final String MVN_VERSION_RESOURCE_FILE = "META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String BROOKLYN_CORE_SYMBOLIC_NAME = "org.apache.brooklyn.core";
    private static final String MVN_VERSION_PROPERTY_NAME = "version";
    private static final String OSGI_VERSION_PROPERTY_NAME = Attributes.Name.IMPLEMENTATION_VERSION.toString();
    private static final String OSGI_SHA1_PROPERTY_NAME = "Implementation-SHA-1";
    private static final String VERSION_FROM_STATIC = "1.0.0";
    private static final AtomicReference<Boolean> IS_DEV_ENV = new AtomicReference();
    private static final String BROOKLYN_FEATURE_PREFIX = "Brooklyn-Feature-";
    public static final BrooklynVersion INSTANCE = new BrooklynVersion();
    private final Properties versionProperties = new Properties();

    private BrooklynVersion() {
        this.readPropertiesFromMavenResource(BrooklynVersion.class.getClassLoader());
        this.readPropertiesFromOsgiResource();
        this.checkVersions();
    }

    @Override
    public void checkVersions() {
        String mvnVersion = this.getVersionFromMavenProperties();
        if (mvnVersion != null && !VERSION_FROM_STATIC.equals(mvnVersion)) {
            throw new IllegalStateException("Version error: maven " + mvnVersion + " / code " + VERSION_FROM_STATIC);
        }
        String osgiVersion = this.versionProperties.getProperty(OSGI_VERSION_PROPERTY_NAME);
        if (osgiVersion != null && !VERSION_FROM_STATIC.equals(osgiVersion)) {
            throw new IllegalStateException("Version error: osgi " + osgiVersion + " / code " + VERSION_FROM_STATIC);
        }
    }

    @Override
    @Nullable
    public String getVersionFromMavenProperties() {
        return this.versionProperties.getProperty(MVN_VERSION_PROPERTY_NAME);
    }

    @Override
    @Nullable
    public String getVersionFromOsgiManifest() {
        return this.versionProperties.getProperty(OSGI_VERSION_PROPERTY_NAME);
    }

    @Override
    @Nullable
    public String getSha1FromOsgiManifest() {
        return this.versionProperties.getProperty(OSGI_SHA1_PROPERTY_NAME);
    }

    @Override
    public String getVersion() {
        return VERSION_FROM_STATIC;
    }

    @Override
    public boolean isSnapshot() {
        return VersionComparator.isSnapshot((String)this.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromMavenResource(ClassLoader resourceLoader) {
        InputStream versionStream = null;
        try {
            versionStream = resourceLoader.getResourceAsStream(MVN_VERSION_RESOURCE_FILE);
            if (versionStream == null) {
                if (BrooklynVersion.isDevelopmentEnvironment()) {
                    log.trace("No maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties available");
                } else {
                    log.warn("No maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties available");
                }
                return;
            }
            this.versionProperties.load((InputStream)Preconditions.checkNotNull((Object)versionStream));
        }
        catch (IOException e) {
            log.warn("Error reading maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties: " + e, (Throwable)e);
        }
        finally {
            Streams.closeQuietly((Closeable)versionStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromOsgiResource() {
        if (OsgiUtil.isBrooklynInsideFramework()) {
            Dictionary headers = FrameworkUtil.getBundle(BrooklynVersion.class).getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.versionProperties.put(key, headers.get(key));
            }
        } else {
            Enumeration<URL> paths;
            try {
                paths = BrooklynVersion.class.getClassLoader().getResources(MANIFEST_PATH);
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            while (paths.hasMoreElements()) {
                URL u = paths.nextElement();
                InputStream us = null;
                try {
                    us = u.openStream();
                    ManifestHelper mh = ManifestHelper.forManifest((InputStream)us);
                    if (!BROOKLYN_CORE_SYMBOLIC_NAME.equals(mh.getSymbolicName())) continue;
                    Attributes attrs = mh.getManifest().getMainAttributes();
                    for (Object key : attrs.keySet()) {
                        this.versionProperties.put(key.toString(), attrs.getValue(key.toString()));
                    }
                    return;
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.warn("Error reading OSGi manifest from " + u + " when determining version properties: " + e, (Throwable)e);
                }
                finally {
                    Streams.closeQuietly((Closeable)us);
                }
            }
            if (BrooklynVersion.isDevelopmentEnvironment()) {
                log.trace("No OSGi manifest available to determine version properties");
            } else {
                log.warn("No OSGi manifest available to determine version properties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDevelopmentEnvironment() {
        Boolean isDevEnv = IS_DEV_ENV.get();
        if (isDevEnv != null) {
            return isDevEnv;
        }
        AtomicReference<Boolean> atomicReference = IS_DEV_ENV;
        synchronized (atomicReference) {
            isDevEnv = BrooklynVersion.computeIsDevelopmentEnvironment();
            IS_DEV_ENV.set(isDevEnv);
            return isDevEnv;
        }
    }

    private static boolean computeIsDevelopmentEnvironment() {
        Enumeration<URL> paths;
        try {
            paths = BrooklynVersion.class.getClassLoader().getResources("org/apache/brooklyn/core/BrooklynVersion.class");
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        while (paths.hasMoreElements()) {
            URL u = paths.nextElement();
            if (!u.getPath().endsWith("org/apache/brooklyn/core/BrooklynVersion.class")) continue;
            try {
                log.debug("Brooklyn dev/src environment detected: BrooklynVersion class is at: " + u);
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Error reading manifest to determine whether this is a development environment: " + e, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void logSummary() {
        log.debug("Brooklyn version " + this.getVersion() + " (git SHA1 " + this.getSha1FromOsgiManifest() + ")");
    }

    public static String get() {
        return INSTANCE.getVersion();
    }

    public static BrooklynVersion getInstance() {
        return INSTANCE;
    }

    public static Iterable<BrooklynFeature> getFeatures(ManagementContext mgmt) {
        if (OsgiUtil.isBrooklynInsideFramework()) {
            ArrayList bundles = Lists.newArrayList((Object[])FrameworkUtil.getBundle(BrooklynVersion.class).getBundleContext().getBundles());
            Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
            if (osgi.isPresentAndNonNull()) {
                for (ManagedBundle b : ((OsgiManager)osgi.get()).getManagedBundles().values()) {
                    Maybe<Bundle> osgiBundle = ((OsgiManager)osgi.get()).findBundle((OsgiBundleWithUrl)b);
                    if (!osgiBundle.isPresentAndNonNull()) continue;
                    bundles.add(osgiBundle.get());
                }
                for (RegisteredType t : mgmt.getTypeRegistry().getAll()) {
                    for (OsgiBundleWithUrl catalogBundle : t.getLibraries()) {
                        Maybe<Bundle> osgiBundle = ((OsgiManager)osgi.get()).findBundle(catalogBundle);
                        if (!osgiBundle.isPresentAndNonNull()) continue;
                        bundles.add(osgiBundle.get());
                    }
                }
            }
            ImmutableSet.Builder features = ImmutableSet.builder();
            for (Bundle bundle : bundles) {
                Optional fs = BrooklynFeature.newFeature(bundle.getHeaders());
                if (!fs.isPresent()) continue;
                features.add(fs.get());
            }
            return features.build();
        }
        MutableSet manifests = MutableSet.copyOf(ResourceUtils.create(mgmt).getResources(MANIFEST_PATH));
        Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
        if (osgi.isPresentAndNonNull()) {
            Iterables.addAll((Collection)manifests, ((OsgiManager)osgi.get()).getResources(MANIFEST_PATH, ((OsgiManager)osgi.get()).getManagedBundles().values()));
        }
        for (RegisteredType t : mgmt.getTypeRegistry().getAll()) {
            OsgiBrooklynClassLoadingContext osgiContext = new OsgiBrooklynClassLoadingContext(mgmt, t.getId(), t.getLibraries());
            Iterables.addAll((Collection)manifests, osgiContext.getResources(MANIFEST_PATH));
        }
        ImmutableSet.Builder features = ImmutableSet.builder();
        for (URL manifest : manifests) {
            Attributes attrs;
            Optional fs;
            ManifestHelper mh = null;
            try {
                mh = ManifestHelper.forManifest((URL)manifest);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.debug("Error reading OSGi manifest from " + manifest + " when determining version properties: " + e, (Throwable)e);
            }
            if (mh == null || !(fs = BrooklynFeature.newFeature(attrs = mh.getManifest().getMainAttributes())).isPresent()) continue;
            features.add(fs.get());
        }
        return features.build();
    }

    public static String getOsgiVersion() {
        return BrooklynVersionSyntax.toValidOsgiVersion((String)BrooklynVersion.get());
    }

    public static class BrooklynFeature {
        private final String name;
        private final String symbolicName;
        private final String version;
        private final String lastModified;
        private final Map<String, String> additionalData;

        BrooklynFeature(String name, String symbolicName, String version, String lastModified, Map<String, String> additionalData) {
            this.symbolicName = (String)Preconditions.checkNotNull((Object)symbolicName, (Object)"symbolicName");
            this.name = name;
            this.version = version;
            this.lastModified = lastModified;
            this.additionalData = ImmutableMap.copyOf(additionalData);
        }

        private static Optional<BrooklynFeature> newFeature(Attributes attrs) {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            for (Map.Entry<Object, Object> entry : attrs.entrySet()) {
                ((Dictionary)headers).put(entry.getKey().toString(), entry.getValue().toString());
            }
            return BrooklynFeature.newFeature(headers);
        }

        private static Optional<BrooklynFeature> newFeature(Dictionary<String, String> headers) {
            HashMap additionalData = Maps.newHashMap();
            Enumeration<String> keys = headers.keys();
            while (keys.hasMoreElements()) {
                String value;
                String key = keys.nextElement();
                if (!key.startsWith(BrooklynVersion.BROOKLYN_FEATURE_PREFIX) || Strings.isBlank((CharSequence)(value = headers.get(key)))) continue;
                additionalData.put(key, value);
            }
            if (additionalData.isEmpty()) {
                return Optional.absent();
            }
            String nameKey = "Brooklyn-Feature-Name";
            String name = (String)Optional.fromNullable(additionalData.remove(nameKey)).or(Optional.fromNullable((Object)"Bundle-Name")).or((Object)headers.get("Bundle-SymbolicName"));
            return Optional.of((Object)new BrooklynFeature(name, headers.get("Bundle-SymbolicName"), headers.get("Bundle-Version"), headers.get("Bnd-LastModified"), additionalData));
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String getVersion() {
            return this.version;
        }

        public Map<String, String> getAdditionalData() {
            return this.additionalData;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.symbolicName + (this.version != null ? ":" + this.version : "") + "}";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.version});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BrooklynFeature that = (BrooklynFeature)other;
            if (!this.symbolicName.equals(that.symbolicName)) {
                return false;
            }
            return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
        }
    }
}

