/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.time.Duration;

public class EntityTasks {
    public static <T> Task<Boolean> testingAttributeEventually(Entity entity, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReady(entity, sensor).readiness(condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutReturn(false).onUnmanagedReturn(false).build();
    }

    public static <T> Task<Boolean> requiringAttributeEventually(Entity entity, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReady(entity, sensor).readiness(condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutThrow().onUnmanagedThrow().build();
    }

    public static <T> Task<Boolean> testingAttributeEventually(Iterable<Entity> entities, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutReturn(false).onUnmanagedReturn(false).postProcessFromMultiple((Predicate<List<Boolean>>)CollectionFunctionals.all((Predicate)Predicates.equalTo((Object)true))).build();
    }

    public static <T> Task<Boolean> requiringAttributeEventually(Iterable<Entity> entities, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutThrow().onUnmanagedThrow().postProcessFromMultiple(CollectionFunctionals.all((Predicate)Predicates.equalTo((Object)true))).build();
    }
}

