/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class DynamicThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger activeCount = new AtomicInteger();

    DynamicThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    public int getActiveCount() {
        return this.activeCount.get();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.activeCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.activeCount.decrementAndGet();
    }

    static class TimedBlockingPolicy
    implements RejectedExecutionHandler {
        private final long waitTime;

        TimedBlockingPolicy(long waitTime) {
            this.waitTime = waitTime;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Rejected execution of task [" + r.getClass() + "] since the executor is shutdown.");
            }
            try {
                boolean successful = executor.getQueue().offer(r, this.waitTime, TimeUnit.MILLISECONDS);
                if (!successful) {
                    throw new RejectedExecutionException("Rejected execution after waiting " + this.waitTime + " ms for task [" + r.getClass() + "] to be executed.");
                }
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    static class ForceQueuePolicy
    implements RejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Rejected execution of task [" + r.getClass() + "] since the executor is shutdown.");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    static class DynamicQueue<E>
    extends LinkedBlockingQueue<E> {
        private static final long serialVersionUID = 1L;
        private transient ThreadPoolExecutor executor;

        public DynamicQueue() {
        }

        DynamicQueue(int capacity) {
            super(capacity);
        }

        public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public boolean offer(E o) {
            int allWorkingThreads = this.executor.getActiveCount() + super.size();
            return allWorkingThreads < this.executor.getPoolSize() && super.offer(o);
        }
    }
}

