/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.lookup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.camp.brooklyn.spi.lookup.AbstractBrooklynResourceLookup;
import org.apache.brooklyn.camp.brooklyn.spi.lookup.BrooklynUrlLookup;
import org.apache.brooklyn.camp.brooklyn.spi.lookup.PlatformComponentBrooklynLookup;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.camp.spi.collection.ResolvableLink;

public class AssemblyBrooklynLookup
extends AbstractBrooklynResourceLookup<Assembly> {
    private PlatformComponentBrooklynLookup pcs;

    public AssemblyBrooklynLookup(PlatformRootSummary root, ManagementContext bmc, PlatformComponentBrooklynLookup pcs) {
        super(root, bmc);
        this.pcs = pcs;
    }

    public Assembly get(String id) {
        Entity entity = this.bmc.getEntityManager().getEntity(id);
        if (!(entity instanceof Application)) {
            throw new IllegalArgumentException("Element for " + id + " is not an Application (" + entity + ")");
        }
        Assembly.Builder builder = (Assembly.Builder)((Assembly.Builder)((Assembly.Builder)Assembly.builder().created(new Date(entity.getCreationTime()))).id(entity.getId())).name(entity.getDisplayName());
        builder.customAttribute("externalManagementUri", (Object)BrooklynUrlLookup.getUrl(this.bmc, entity));
        for (Entity child : entity.getChildren()) {
            builder.add(this.pcs.get(child.getId()));
        }
        return builder.build();
    }

    public List<ResolvableLink<Assembly>> links() {
        ArrayList<ResolvableLink<Assembly>> result = new ArrayList<ResolvableLink<Assembly>>();
        for (Application app : this.bmc.getApplications()) {
            result.add((ResolvableLink<Assembly>)this.newLink(app.getId(), app.getDisplayName()));
        }
        return result;
    }
}

