/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.domain;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.b2.domain.Action;
import org.jclouds.b2.domain.AutoValue_B2ObjectList;
import org.jclouds.b2.domain.AutoValue_B2ObjectList_Entry;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class B2ObjectList {
    public abstract List<Entry> files();

    @Nullable
    public abstract String nextFileId();

    @Nullable
    public abstract String nextFileName();

    @SerializedNames(value={"files", "nextFileId", "nextFileName"})
    public static B2ObjectList create(List<Entry> files, @Nullable String nextFileId, @Nullable String nextFileName) {
        return new AutoValue_B2ObjectList((List<Entry>)ImmutableList.copyOf(files), nextFileId, nextFileName);
    }

    public static abstract class Entry {
        public abstract Action action();

        @Nullable
        public abstract String fileId();

        public abstract String fileName();

        public abstract long size();

        public abstract Date uploadTimestamp();

        @SerializedNames(value={"action", "fileId", "fileName", "size", "uploadTimestamp"})
        public static Entry create(Action action, @Nullable String fileId, String fileName, long size, long uploadTimestamp) {
            return new AutoValue_B2ObjectList_Entry(action, fileId, fileName, size, new Date(uploadTimestamp));
        }
    }
}

