/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.windows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.feed.AbstractCommandFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;

public class CmdFeed
extends AbstractCommandFeed {
    public static Builder builder() {
        return new Builder();
    }

    public CmdFeed() {
    }

    protected CmdFeed(Builder builder) {
        super((AbstractCommandFeed.Builder)builder);
    }

    protected SshPollValue exec(String command, Map<String, String> env) throws IOException {
        WinRmMachineLocation machine = (WinRmMachineLocation)this.getMachine();
        if (log.isTraceEnabled()) {
            log.trace("WinRm polling for {}, executing {} with env {}", new Object[]{machine, command, env});
        }
        ConfigBag flags = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag()).configure(WinRmTool.ENVIRONMENT, env);
        WinRmToolResponse winRmToolResponse = machine.executeCommand(flags.getAllConfig(), (List<String>)ImmutableList.of((Object)command));
        int exitStatus = winRmToolResponse.getStatusCode();
        return new SshPollValue(null, exitStatus, winRmToolResponse.getStdOut(), winRmToolResponse.getStdErr());
    }

    public static class Builder
    extends AbstractCommandFeed.Builder<CmdFeed, Builder> {
        private List<CommandPollConfig<?>> polls = Lists.newArrayList();

        public Builder poll(CommandPollConfig<?> config) {
            this.polls.add(config);
            return this.self();
        }

        public List<CommandPollConfig<?>> getPolls() {
            return this.polls;
        }

        protected Builder self() {
            return this;
        }

        protected CmdFeed instantiateFeed() {
            return new CmdFeed(this);
        }
    }
}

