/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.tomcat;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatDriver;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatServer;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatServerImpl
extends JavaWebAppSoftwareProcessImpl
implements TomcatServer {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerImpl.class);
    private volatile JmxFeed jmxWebFeed;
    private volatile JmxFeed jmxAppFeed;

    public void connectSensors() {
        super.connectSensors();
        if (this.getDriver().isJmxEnabled()) {
            String requestProcessorMbeanName = "Catalina:type=GlobalRequestProcessor,name=\"http-*\"";
            Integer port = this.isHttpsEnabled() ? (Integer)this.getAttribute((AttributeSensor)HTTPS_PORT) : (Integer)this.getAttribute((AttributeSensor)HTTP_PORT);
            String connectorMbeanName = String.format("Catalina:type=Connector,port=%s", port);
            boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
            this.jmxWebFeed = JmxFeed.builder().entity((Entity)this).period(3000L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_PROCESS_IS_RUNNING).objectName(connectorMbeanName).attributeName("stateName").onSuccess(Functions.forPredicate((Predicate)Predicates.equalTo((Object)"STARTED")))).setOnFailureOrException((Object)false)).suppressDuplicates(true)).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(CONNECTOR_STATUS).objectName(connectorMbeanName).attributeName("stateName").suppressDuplicates(true)).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig((AttributeSensor)ERROR_COUNT).objectName(requestProcessorMbeanName).attributeName("errorCount").enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(REQUEST_COUNT).objectName(requestProcessorMbeanName).attributeName("requestCount").enabled(retrieveUsageMetrics)).onFailureOrException(EntityFunctions.attribute((Entity)this, (AttributeSensor)REQUEST_COUNT))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(TOTAL_PROCESSING_TIME).objectName(requestProcessorMbeanName).attributeName("processingTime").enabled(retrieveUsageMetrics)).build();
            this.jmxAppFeed = JavaAppUtils.connectMXBeanSensors((Entity)this);
        } else {
            LOG.warn("Tomcat running without JMX monitoring; limited visibility of service available");
            this.connectServiceUpIsRunning();
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.getDriver() != null && this.getDriver().isJmxEnabled()) {
            if (this.jmxWebFeed != null) {
                this.jmxWebFeed.stop();
            }
            if (this.jmxAppFeed != null) {
                this.jmxAppFeed.stop();
            }
        } else {
            this.disconnectServiceUpIsRunning();
        }
    }

    public Class getDriverInterface() {
        return TomcatDriver.class;
    }

    public String getShortName() {
        return "Tomcat";
    }
}

