/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.SpeculativeRequestExecutor;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingReadOp
implements Enumeration<LedgerEntry>,
BookkeeperInternalCallbacks.ReadEntryCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PendingReadOp.class);
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> speculativeTask = null;
    Queue<LedgerEntryRequest> seq;
    Set<BookieSocketAddress> heardFromHosts;
    BitSet heardFromHostsBitSet;
    AsyncCallback.ReadCallback cb;
    Object ctx;
    LedgerHandle lh;
    long numPendingEntries;
    long startEntryId;
    long endEntryId;
    long requestTimeNanos;
    OpStatsLogger readOpLogger;
    final int maxMissedReadsAllowed;
    boolean parallelRead = false;
    final AtomicBoolean complete = new AtomicBoolean(false);

    PendingReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, AsyncCallback.ReadCallback cb, Object ctx) {
        this.seq = new ArrayBlockingQueue<LedgerEntryRequest>((int)(endEntryId + 1L - startEntryId));
        this.cb = cb;
        this.ctx = ctx;
        this.lh = lh;
        this.startEntryId = startEntryId;
        this.endEntryId = endEntryId;
        this.scheduler = scheduler;
        this.numPendingEntries = endEntryId - startEntryId + 1L;
        this.maxMissedReadsAllowed = this.getLedgerMetadata().getWriteQuorumSize() - this.getLedgerMetadata().getAckQuorumSize();
        this.heardFromHosts = new HashSet<BookieSocketAddress>();
        this.heardFromHostsBitSet = new BitSet(this.getLedgerMetadata().getEnsembleSize());
        this.readOpLogger = lh.bk.getReadOpLogger();
    }

    protected LedgerMetadata getLedgerMetadata() {
        return this.lh.metadata;
    }

    protected void cancelSpeculativeTask(boolean mayInterruptIfRunning) {
        if (this.speculativeTask != null) {
            this.speculativeTask.cancel(mayInterruptIfRunning);
            this.speculativeTask = null;
        }
    }

    PendingReadOp parallelRead(boolean enabled) {
        this.parallelRead = enabled;
        return this;
    }

    public void initiate() {
        long nextEnsembleChange = this.startEntryId;
        long i = this.startEntryId;
        this.requestTimeNanos = MathUtils.nowInNano();
        ArrayList<BookieSocketAddress> ensemble = null;
        do {
            if (i == nextEnsembleChange) {
                ensemble = this.getLedgerMetadata().getEnsemble(i);
                nextEnsembleChange = this.getLedgerMetadata().getNextEnsembleChange(i);
            }
            LedgerEntryRequest entry = this.parallelRead ? new ParallelReadRequest(ensemble, this.lh.ledgerId, i) : new SequenceReadRequest(ensemble, this.lh.ledgerId, i);
            this.seq.add(entry);
        } while (++i <= this.endEntryId);
        for (LedgerEntryRequest entry : this.seq) {
            entry.read();
            if (this.parallelRead || !this.lh.bk.getReadSpeculativeRequestPolicy().isPresent()) continue;
            this.lh.bk.getReadSpeculativeRequestPolicy().get().initiateSpeculativeRequest(this.scheduler, entry);
        }
    }

    void sendReadTo(int bookieIndex, BookieSocketAddress to, LedgerEntryRequest entry) throws InterruptedException {
        if (this.lh.throttler != null) {
            this.lh.throttler.acquire();
        }
        this.lh.bk.bookieClient.readEntry(to, this.lh.ledgerId, entry.entryId, this, new ReadContext(bookieIndex, to, entry));
    }

    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        ReadContext rctx = (ReadContext)ctx;
        LedgerEntryRequest entry = rctx.entry;
        if (rc != 0) {
            entry.logErrorAndReattemptRead(rctx.bookieIndex, rctx.to, "Error: " + BKException.getMessage(rc), rc);
            return;
        }
        this.heardFromHosts.add(rctx.to);
        this.heardFromHostsBitSet.set(rctx.bookieIndex, true);
        if (entry.complete(rctx.bookieIndex, rctx.to, buffer)) {
            this.lh.updateLastConfirmed(rctx.getLastAddConfirmed(), 0L);
            this.submitCallback(0);
        }
        if (this.numPendingEntries < 0L) {
            LOG.error("Read too many values for ledger {} : [{}, {}].", new Object[]{ledgerId, this.startEntryId, this.endEntryId});
        }
    }

    protected void submitCallback(int code) {
        if (0 == code) {
            --this.numPendingEntries;
            if (this.numPendingEntries != 0L) {
                return;
            }
        }
        if (!this.complete.compareAndSet(false, true)) {
            return;
        }
        long latencyNanos = MathUtils.elapsedNanos(this.requestTimeNanos);
        if (code != 0) {
            long firstUnread = -1L;
            for (LedgerEntryRequest req : this.seq) {
                if (req.isComplete()) continue;
                firstUnread = req.getEntryId();
                break;
            }
            LOG.error("Read of ledger entry failed: L{} E{}-E{}, Heard from {} : bitset = {}. First unread entry is {}", new Object[]{this.lh.getId(), this.startEntryId, this.endEntryId, this.heardFromHosts, this.heardFromHostsBitSet, firstUnread});
            this.readOpLogger.registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
        } else {
            this.readOpLogger.registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
        }
        this.cancelSpeculativeTask(true);
        this.cb.readComplete(code, this.lh, this, this.ctx);
        this.cb = null;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.seq.isEmpty();
    }

    @Override
    public LedgerEntry nextElement() throws NoSuchElementException {
        return this.seq.remove();
    }

    public int size() {
        return this.seq.size();
    }

    private static class ReadContext
    implements BookkeeperInternalCallbacks.ReadEntryCallbackCtx {
        final int bookieIndex;
        final BookieSocketAddress to;
        final LedgerEntryRequest entry;
        long lac = -1L;

        ReadContext(int bookieIndex, BookieSocketAddress to, LedgerEntryRequest entry) {
            this.bookieIndex = bookieIndex;
            this.to = to;
            this.entry = entry;
        }

        @Override
        public void setLastAddConfirmed(long lac) {
            this.lac = lac;
        }

        @Override
        public long getLastAddConfirmed() {
            return this.lac;
        }
    }

    class SequenceReadRequest
    extends LedgerEntryRequest {
        static final int NOT_FOUND = -1;
        int nextReplicaIndexToReadFrom;
        final BitSet sentReplicas;
        final BitSet erroredReplicas;

        SequenceReadRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.nextReplicaIndexToReadFrom = 0;
            this.sentReplicas = new BitSet(PendingReadOp.this.lh.getLedgerMetadata().getWriteQuorumSize());
            this.erroredReplicas = new BitSet(PendingReadOp.this.lh.getLedgerMetadata().getWriteQuorumSize());
        }

        private synchronized int getNextReplicaIndexToReadFrom() {
            return this.nextReplicaIndexToReadFrom;
        }

        private int getReplicaIndex(int bookieIndex) {
            return this.writeSet.indexOf(bookieIndex);
        }

        private BitSet getSentToBitSet() {
            BitSet b = new BitSet(this.ensemble.size());
            for (int i = 0; i < this.sentReplicas.length(); ++i) {
                if (!this.sentReplicas.get(i)) continue;
                b.set((Integer)this.writeSet.get(i));
            }
            return b;
        }

        private boolean readsOutstanding() {
            return this.sentReplicas.cardinality() - this.erroredReplicas.cardinality() > 0;
        }

        @Override
        synchronized BookieSocketAddress maybeSendSpeculativeRead(BitSet heardFrom) {
            if (this.nextReplicaIndexToReadFrom >= PendingReadOp.this.getLedgerMetadata().getWriteQuorumSize()) {
                return null;
            }
            BitSet sentTo = this.getSentToBitSet();
            sentTo.and(heardFrom);
            if (sentTo.cardinality() == 0) {
                return this.sendNextRead();
            }
            return null;
        }

        @Override
        void read() {
            this.sendNextRead();
        }

        synchronized BookieSocketAddress sendNextRead() {
            if (this.nextReplicaIndexToReadFrom >= PendingReadOp.this.getLedgerMetadata().getWriteQuorumSize()) {
                if (-8 == this.firstError && this.numMissedEntryReads > PendingReadOp.this.maxMissedReadsAllowed) {
                    this.firstError = -13;
                }
                this.fail(this.firstError);
                return null;
            }
            int replica = this.nextReplicaIndexToReadFrom;
            int bookieIndex = PendingReadOp.this.lh.distributionSchedule.getWriteSet(this.entryId).get(this.nextReplicaIndexToReadFrom);
            ++this.nextReplicaIndexToReadFrom;
            try {
                BookieSocketAddress to = (BookieSocketAddress)this.ensemble.get(bookieIndex);
                PendingReadOp.this.sendReadTo(bookieIndex, to, this);
                this.sentReplicas.set(replica);
                return to;
            }
            catch (InterruptedException ie) {
                LOG.error("Interrupted reading entry " + this, (Throwable)ie);
                Thread.currentThread().interrupt();
                this.fail(-15);
                return null;
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            int replica = this.getReplicaIndex(bookieIndex);
            if (replica == -1) {
                LOG.error("Received error from a host which is not in the ensemble {} {}.", (Object)host, (Object)this.ensemble);
                return;
            }
            this.erroredReplicas.set(replica);
            if (!this.readsOutstanding()) {
                this.sendNextRead();
            }
        }
    }

    class ParallelReadRequest
    extends LedgerEntryRequest {
        int numPendings;

        ParallelReadRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.numPendings = this.writeSet.size();
        }

        @Override
        void read() {
            Iterator iterator = this.writeSet.iterator();
            while (iterator.hasNext()) {
                int bookieIndex = (Integer)iterator.next();
                BookieSocketAddress to = (BookieSocketAddress)this.ensemble.get(bookieIndex);
                try {
                    PendingReadOp.this.sendReadTo(bookieIndex, to, this);
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted reading entry {} : ", (Object)this, (Object)ie);
                    Thread.currentThread().interrupt();
                    this.fail(-15);
                    return;
                }
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            --this.numPendings;
            if (this.numMissedEntryReads > PendingReadOp.this.maxMissedReadsAllowed || this.numPendings == 0) {
                if (-8 == this.firstError && this.numMissedEntryReads > PendingReadOp.this.maxMissedReadsAllowed) {
                    this.firstError = -13;
                }
                this.fail(this.firstError);
            }
        }

        @Override
        BookieSocketAddress maybeSendSpeculativeRead(BitSet heardFromHostsBitSet) {
            return null;
        }
    }

    abstract class LedgerEntryRequest
    extends LedgerEntry
    implements SpeculativeRequestExecutor {
        final AtomicBoolean complete;
        int rc;
        int firstError;
        int numMissedEntryReads;
        final ArrayList<BookieSocketAddress> ensemble;
        final List<Integer> writeSet;

        LedgerEntryRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(lId, eId);
            this.complete = new AtomicBoolean(false);
            this.rc = 0;
            this.firstError = 0;
            this.numMissedEntryReads = 0;
            this.ensemble = ensemble;
            this.writeSet = PendingReadOp.this.lh.bk.reorderReadSequence ? PendingReadOp.this.lh.bk.placementPolicy.reorderReadSequence(ensemble, PendingReadOp.this.lh.distributionSchedule.getWriteSet(this.entryId), PendingReadOp.this.lh.bookieFailureHistory.asMap()) : PendingReadOp.this.lh.distributionSchedule.getWriteSet(this.entryId);
        }

        abstract void read();

        boolean complete(int bookieIndex, BookieSocketAddress host, ByteBuf buffer) {
            ByteBuf content;
            try {
                content = PendingReadOp.this.lh.macManager.verifyDigestAndReturnData(this.entryId, buffer);
            }
            catch (BKException.BKDigestMatchException e) {
                this.logErrorAndReattemptRead(bookieIndex, host, "Mac mismatch", -5);
                buffer.release();
                return false;
            }
            if (!this.complete.getAndSet(true)) {
                this.rc = 0;
                this.length = buffer.getLong(24);
                this.data = content;
                return true;
            }
            buffer.release();
            return false;
        }

        boolean fail(int rc) {
            if (this.complete.compareAndSet(false, true)) {
                this.rc = rc;
                PendingReadOp.this.submitCallback(rc);
                return true;
            }
            return false;
        }

        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            if (0 == this.firstError || -13 == this.firstError || -7 == this.firstError) {
                this.firstError = rc;
            } else if (-8 == this.firstError && -13 != rc && -7 != rc) {
                this.firstError = rc;
            }
            if (-13 == rc || -7 == rc) {
                ++this.numMissedEntryReads;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No such entry found on bookie.  L{} E{} bookie: {}", new Object[]{PendingReadOp.this.lh.ledgerId, this.entryId, host});
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(errMsg + " while reading L{} E{} from bookie: {}", new Object[]{PendingReadOp.this.lh.ledgerId, this.entryId, host});
            }
        }

        abstract BookieSocketAddress maybeSendSpeculativeRead(BitSet var1);

        boolean isComplete() {
            return this.complete.get();
        }

        int getRc() {
            return this.rc;
        }

        public String toString() {
            return String.format("L%d-E%d", this.ledgerId, this.entryId);
        }

        @Override
        public ListenableFuture<Boolean> issueSpeculativeRequest() {
            return PendingReadOp.this.lh.bk.mainWorkerPool.submitOrdered((Object)PendingReadOp.this.lh.getId(), new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (!LedgerEntryRequest.this.isComplete() && null != LedgerEntryRequest.this.maybeSendSpeculativeRead(PendingReadOp.this.heardFromHostsBitSet)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Send speculative read for {}. Hosts heard are {}, ensemble is {}.", new Object[]{this, PendingReadOp.this.heardFromHostsBitSet, LedgerEntryRequest.this.ensemble});
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
    }
}

