/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingAddOp
implements BookkeeperInternalCallbacks.WriteCallback,
TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PendingAddOp.class);
    ByteBuf toSend;
    AsyncCallback.AddCallback cb;
    Object ctx;
    long entryId;
    int entryLength;
    Set<Integer> writeSet;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    LedgerHandle lh;
    boolean isRecoveryAdd = false;
    long requestTimeNanos;
    final int timeoutSec;
    Timeout timeout = null;
    OpStatsLogger addOpLogger;
    boolean callbackTriggered = false;

    PendingAddOp(LedgerHandle lh, AsyncCallback.AddCallback cb, Object ctx) {
        this.lh = lh;
        this.cb = cb;
        this.ctx = ctx;
        this.entryId = -1L;
        this.ackSet = lh.distributionSchedule.getAckSet();
        this.addOpLogger = lh.bk.getAddOpLogger();
        this.timeoutSec = lh.bk.getConf().getAddEntryQuorumTimeout();
    }

    PendingAddOp enableRecoveryAdd() {
        this.isRecoveryAdd = true;
        return this;
    }

    void setEntryId(long entryId) {
        this.entryId = entryId;
        this.writeSet = new HashSet<Integer>(this.lh.distributionSchedule.getWriteSet(entryId));
    }

    long getEntryId() {
        return this.entryId;
    }

    void sendWriteRequest(int bookieIndex) {
        int flags = this.isRecoveryAdd ? 2 : 0;
        this.lh.bk.bookieClient.addEntry(this.lh.metadata.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.entryId, this.toSend, this, bookieIndex, flags);
    }

    public void run(Timeout timeout) {
        this.timeoutQuorumWait();
    }

    void timeoutQuorumWait() {
        try {
            this.lh.bk.mainWorkerPool.submitOrdered(this.lh.ledgerId, new SafeRunnable(){

                @Override
                public void safeRun() {
                    if (PendingAddOp.this.completed) {
                        return;
                    }
                    PendingAddOp.this.lh.handleUnrecoverableErrorDuringAdd(-21);
                }

                public String toString() {
                    return String.format("AddEntryQuorumTimeout(lid=%d, eid=%d)", PendingAddOp.this.lh.ledgerId, PendingAddOp.this.entryId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Timeout add entry quorum wait failed {} entry: {}", (Object)this.lh.ledgerId, (Object)this.entryId);
        }
    }

    void unsetSuccessAndSendWriteRequest(int bookieIndex) {
        if (this.toSend == null) {
            return;
        }
        if (!this.writeSet.contains(bookieIndex)) {
            this.lh.sendAddSuccessCallbacks();
            return;
        }
        if (this.callbackTriggered) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsetting success for ledger: " + this.lh.ledgerId + " entry: " + this.entryId + " bookie index: " + bookieIndex);
        }
        if (!this.ackSet.removeBookieAndCheck(bookieIndex)) {
            this.completed = false;
        }
        this.sendWriteRequest(bookieIndex);
    }

    void initiate(ByteBuf toSend, int entryLength) {
        if (this.callbackTriggered) {
            return;
        }
        if (this.timeoutSec > -1) {
            this.timeout = this.lh.bk.bookieClient.scheduleTimeout(this, this.timeoutSec, TimeUnit.SECONDS);
        }
        this.requestTimeNanos = MathUtils.nowInNano();
        this.toSend = toSend;
        this.toSend.retain();
        this.entryLength = entryLength;
        for (int bookieIndex : this.writeSet) {
            this.sendWriteRequest(bookieIndex);
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        if (!this.lh.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write did not succeed: " + ledgerId + ", " + entryId + ". But we have already fixed it.");
            }
            return;
        }
        boolean ackQuorum = false;
        if (0 == rc) {
            ackQuorum = this.ackSet.completeBookieAndCheck(bookieIndex);
        }
        if (this.completed) {
            this.sendAddSuccessCallbacks();
            return;
        }
        switch (rc) {
            case 0: {
                break;
            }
            case -19: {
                this.lh.errorOutPendingAdds(rc);
                return;
            }
            case -101: {
                LOG.warn("Fencing exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            case -102: {
                LOG.warn("Unauthorized access exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            default: {
                if (this.lh.bk.delayEnsembleChange) {
                    if (this.ackSet.failBookieAndCheck(bookieIndex, addr) || rc == -104) {
                        Map<Integer, BookieSocketAddress> failedBookies = this.ackSet.getFailedBookies();
                        LOG.warn("Failed to write entry ({}, {}) to bookies {}, handling failures.", new Object[]{ledgerId, entryId, failedBookies});
                        this.lh.handleBookieFailure(failedBookies);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to write entry ({}, {}) to bookie ({}, {}), but it didn't break ack quorum, delaying ensemble change : {}", new Object[]{ledgerId, entryId, bookieIndex, addr, BKException.getMessage(rc)});
                    }
                } else {
                    LOG.warn("Failed to write entry ({}, {}): {}", new Object[]{ledgerId, entryId, BKException.getMessage(rc)});
                    this.lh.handleBookieFailure(ImmutableMap.of(bookieIndex, addr));
                }
                return;
            }
        }
        if (ackQuorum && !this.completed) {
            this.completed = true;
            this.sendAddSuccessCallbacks();
        }
    }

    void sendAddSuccessCallbacks() {
        this.lh.sendAddSuccessCallbacks();
    }

    void submitCallback(int rc) {
        if (null != this.timeout) {
            this.timeout.cancel();
        }
        ReferenceCountUtil.release((Object)this.toSend);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submit callback (lid:{}, eid: {}). rc:{}", new Object[]{this.lh.getId(), this.entryId, rc});
        }
        long latencyNanos = MathUtils.elapsedNanos(this.requestTimeNanos);
        if (rc != 0) {
            this.addOpLogger.registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
            LOG.error("Write of ledger entry to quorum failed: L{} E{}", (Object)this.lh.getId(), (Object)this.entryId);
        } else {
            this.addOpLogger.registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
        }
        this.cb.addComplete(rc, this.lh, this.entryId, this.ctx);
        this.callbackTriggered = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingAddOp(lid:").append(this.lh.ledgerId).append(", eid:").append(this.entryId).append(", completed:").append(this.completed).append(")");
        return sb.toString();
    }

    public int hashCode() {
        return (int)this.entryId;
    }

    public boolean equals(Object o) {
        if (o instanceof PendingAddOp) {
            return this.entryId == ((PendingAddOp)o).entryId;
        }
        return this == o;
    }
}

