/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.openjdk.tools.javac.util.ListBuffer;

public class CommandLine {
    public static String[] parse(String[] args) throws IOException {
        ListBuffer<String> newArgs = new ListBuffer<String>();
        for (String arg : args) {
            if (arg.length() > 1 && arg.charAt(0) == '@') {
                if ((arg = arg.substring(1)).charAt(0) == '@') {
                    newArgs.append(arg);
                    continue;
                }
                CommandLine.loadCmdFile(arg, newArgs);
                continue;
            }
            newArgs.append(arg);
        }
        return newArgs.toList().toArray(new String[newArgs.length()]);
    }

    private static void loadCmdFile(String name, ListBuffer<String> args) throws IOException {
        try (BufferedReader r = Files.newBufferedReader(Paths.get(name, new String[0]));){
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 32);
            st.commentChar(35);
            st.quoteChar(34);
            st.quoteChar(39);
            while (st.nextToken() != -1) {
                args.append(st.sval);
            }
        }
    }
}

