/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.placement;

import com.twitter.util.Duration;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.service.placement.LoadAppraiser;
import org.apache.distributedlog.service.placement.PlacementPolicy;
import org.apache.distributedlog.service.placement.PlacementStateManager;
import org.apache.distributedlog.service.placement.ServerLoad;
import org.apache.distributedlog.service.placement.StreamLoad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class LeastLoadPlacementPolicy
extends PlacementPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LeastLoadPlacementPolicy.class);
    private TreeSet<ServerLoad> serverLoads = new TreeSet();
    private Map<String, String> streamToServer = new HashMap<String, String>();

    public LeastLoadPlacementPolicy(LoadAppraiser loadAppraiser, RoutingService routingService, Namespace namespace, PlacementStateManager placementStateManager, Duration refreshInterval, StatsLogger statsLogger) {
        super(loadAppraiser, routingService, namespace, placementStateManager, refreshInterval, statsLogger);
        statsLogger.registerGauge("placement/load.diff", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                if (LeastLoadPlacementPolicy.this.serverLoads.size() > 0) {
                    return ((ServerLoad)LeastLoadPlacementPolicy.this.serverLoads.last()).getLoad() - ((ServerLoad)LeastLoadPlacementPolicy.this.serverLoads.first()).getLoad();
                }
                return this.getDefaultValue();
            }
        });
    }

    private synchronized String getStreamOwner(String stream) {
        return this.streamToServer.get(stream);
    }

    @Override
    public Future<String> placeStream(String stream) {
        String streamOwner = this.getStreamOwner(stream);
        if (null != streamOwner) {
            return Future.value((Object)streamOwner);
        }
        Future<StreamLoad> streamLoadFuture = this.loadAppraiser.getStreamLoad(stream);
        return streamLoadFuture.map((Function1)new Function<StreamLoad, String>(){

            public String apply(StreamLoad streamLoad) {
                return LeastLoadPlacementPolicy.this.placeStreamSynchronized(streamLoad);
            }
        });
    }

    private synchronized String placeStreamSynchronized(StreamLoad streamLoad) {
        ServerLoad serverLoad = this.serverLoads.pollFirst();
        serverLoad.addStream(streamLoad);
        this.serverLoads.add(serverLoad);
        return serverLoad.getServer();
    }

    @Override
    public void refresh() {
        logger.info("Refreshing server loads.");
        Future<Void> refresh = this.loadAppraiser.refreshCache();
        final Set<String> servers = this.getServers();
        final Set<String> allStreams = this.getStreams();
        Future serverLoadsFuture = refresh.flatMap((Function1)new Function<Void, Future<TreeSet<ServerLoad>>>(){

            public Future<TreeSet<ServerLoad>> apply(Void v1) {
                return LeastLoadPlacementPolicy.this.calculate(servers, allStreams);
            }
        });
        serverLoadsFuture.map((Function1)new Function<TreeSet<ServerLoad>, BoxedUnit>(){

            public BoxedUnit apply(TreeSet<ServerLoad> serverLoads) {
                try {
                    LeastLoadPlacementPolicy.this.updateServerLoads(serverLoads);
                }
                catch (PlacementStateManager.StateManagerSaveException e) {
                    logger.error("The refreshed mapping could not be persisted and will not be used.", (Throwable)e);
                }
                return BoxedUnit.UNIT;
            }
        });
    }

    private synchronized void updateServerLoads(TreeSet<ServerLoad> serverLoads) throws PlacementStateManager.StateManagerSaveException {
        this.placementStateManager.saveOwnership(serverLoads);
        this.streamToServer = LeastLoadPlacementPolicy.serverLoadsToMap(serverLoads);
        this.serverLoads = serverLoads;
    }

    @Override
    public synchronized void load(TreeSet<ServerLoad> serverLoads) {
        this.serverLoads = serverLoads;
        this.streamToServer = LeastLoadPlacementPolicy.serverLoadsToMap(serverLoads);
    }

    public Future<TreeSet<ServerLoad>> calculate(final Set<String> servers, Set<String> streams) {
        logger.info("Calculating server loads");
        final long startTime = System.currentTimeMillis();
        ArrayList<Future<StreamLoad>> futures = new ArrayList<Future<StreamLoad>>(streams.size());
        for (String stream : streams) {
            Future<StreamLoad> streamLoad = this.loadAppraiser.getStreamLoad(stream);
            futures.add(streamLoad);
        }
        return Futures.collect(futures).map((Function1)new Function<List<StreamLoad>, TreeSet<ServerLoad>>(){

            public TreeSet<ServerLoad> apply(List<StreamLoad> streamLoads) {
                TreeSet<StreamLoad> streamQueue = new TreeSet<StreamLoad>();
                for (StreamLoad streamLoad : streamLoads) {
                    streamQueue.add(streamLoad);
                }
                TreeSet<ServerLoad> serverLoads = new TreeSet<ServerLoad>();
                for (String server : servers) {
                    ServerLoad serverLoad = new ServerLoad(server);
                    if (!streamQueue.isEmpty()) {
                        serverLoad.addStream((StreamLoad)streamQueue.pollFirst());
                    }
                    serverLoads.add(serverLoad);
                }
                while (!streamQueue.isEmpty()) {
                    ServerLoad serverLoad = (ServerLoad)serverLoads.pollFirst();
                    serverLoad.addStream((StreamLoad)streamQueue.pollFirst());
                    serverLoads.add(serverLoad);
                }
                return serverLoads;
            }
        }).onSuccess((Function1)new Function<TreeSet<ServerLoad>, BoxedUnit>(){

            public BoxedUnit apply(TreeSet<ServerLoad> serverLoads) {
                LeastLoadPlacementPolicy.this.placementCalcStats.registerSuccessfulEvent(System.currentTimeMillis() - startTime, TimeUnit.MICROSECONDS);
                return BoxedUnit.UNIT;
            }
        }).onFailure((Function1)new Function<Throwable, BoxedUnit>(){

            public BoxedUnit apply(Throwable t) {
                logger.error("Failure calculating loads", t);
                LeastLoadPlacementPolicy.this.placementCalcStats.registerFailedEvent(System.currentTimeMillis() - startTime, TimeUnit.MICROSECONDS);
                return BoxedUnit.UNIT;
            }
        });
    }

    private static Map<String, String> serverLoadsToMap(Collection<ServerLoad> serverLoads) {
        HashMap<String, String> streamToServer = new HashMap<String, String>(serverLoads.size());
        for (ServerLoad serverLoad : serverLoads) {
            for (StreamLoad streamLoad : serverLoad.getStreamLoads()) {
                streamToServer.put(streamLoad.getStream(), serverLoad.getServer());
            }
        }
        return streamToServer;
    }
}

