/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.injector;

import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.injector.FailureInjector;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDelayFailureInjector
implements FailureInjector {
    private static final Logger LOG = LoggerFactory.getLogger(RandomDelayFailureInjector.class);
    private final DynamicDistributedLogConfiguration dynConf;

    public RandomDelayFailureInjector(DynamicDistributedLogConfiguration dynConf) {
        this.dynConf = dynConf;
    }

    private int delayMs() {
        return this.dynConf.getEIInjectedWriteDelayMs();
    }

    private double delayPct() {
        return this.dynConf.getEIInjectedWriteDelayPercent();
    }

    private boolean enabled() {
        return this.delayMs() > 0 && this.delayPct() > 0.0;
    }

    @Override
    public void inject() {
        try {
            if (this.enabled() && Utils.randomPercent(this.delayPct())) {
                Thread.sleep(this.delayMs());
            }
        }
        catch (InterruptedException ex) {
            LOG.warn("delay was interrupted ", (Throwable)ex);
        }
    }
}

