/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.feature;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeature;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConfigurationListener;
import org.apache.distributedlog.common.config.ConfigurationSubscription;
import org.apache.distributedlog.common.config.PropertiesConfigurationBuilder;
import org.apache.distributedlog.feature.AbstractFeatureProvider;
import org.apache.distributedlog.feature.ConfigurationFeatureProvider;

public class DynamicConfigurationFeatureProvider
extends AbstractFeatureProvider
implements ConfigurationListener {
    private final ConcurrentBaseConfiguration featuresConf;
    private ConfigurationSubscription featuresConfSubscription;
    private final ConcurrentMap<String, SettableFeature> features = new ConcurrentHashMap<String, SettableFeature>();
    private final ScheduledExecutorService executorService;

    public DynamicConfigurationFeatureProvider(String rootScope, DistributedLogConfiguration conf, StatsLogger statsLogger) {
        super(rootScope, conf, statsLogger);
        this.featuresConf = new ConcurrentBaseConfiguration();
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("DynamicConfigurationFeatureProvider-%d").build());
    }

    ConcurrentBaseConfiguration getFeatureConf() {
        return this.featuresConf;
    }

    ConfigurationSubscription getFeatureConfSubscription() {
        return this.featuresConfSubscription;
    }

    @Override
    public void start() throws IOException {
        ArrayList fileConfigBuilders = Lists.newArrayListWithExpectedSize((int)2);
        String baseConfigPath = this.conf.getFileFeatureProviderBaseConfigPath();
        Preconditions.checkNotNull((Object)baseConfigPath);
        File baseConfigFile = new File(baseConfigPath);
        PropertiesConfigurationBuilder baseProperties = new PropertiesConfigurationBuilder(baseConfigFile.toURI().toURL());
        fileConfigBuilders.add(baseProperties);
        String overlayConfigPath = this.conf.getFileFeatureProviderOverlayConfigPath();
        if (null != overlayConfigPath) {
            File overlayConfigFile = new File(overlayConfigPath);
            PropertiesConfigurationBuilder overlayProperties = new PropertiesConfigurationBuilder(overlayConfigFile.toURI().toURL());
            fileConfigBuilders.add(overlayProperties);
        }
        try {
            this.featuresConfSubscription = new ConfigurationSubscription(this.featuresConf, (List)fileConfigBuilders, this.executorService, this.conf.getDynamicConfigReloadIntervalSec(), TimeUnit.SECONDS);
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to register subscription on features configuration");
        }
        this.featuresConfSubscription.registerListener((ConfigurationListener)this);
    }

    @Override
    public void stop() {
        this.executorService.shutdown();
    }

    public void onReload(ConcurrentBaseConfiguration conf) {
        for (Map.Entry feature : this.features.entrySet()) {
            String featureName = (String)feature.getKey();
            int availability = conf.getInt(featureName, 0);
            if (availability == ((SettableFeature)feature.getValue()).availability()) continue;
            ((SettableFeature)feature.getValue()).set(availability);
            logger.info("Reload feature {}={}", (Object)featureName, (Object)availability);
        }
    }

    protected Feature makeFeature(String featureName) {
        return ConfigurationFeatureProvider.makeFeature(this.featuresConf, this.features, featureName);
    }

    protected FeatureProvider makeProvider(String fullScopeName) {
        return new ConfigurationFeatureProvider(fullScopeName, this.featuresConf, this.features);
    }
}

