/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Preconditions;
import com.twitter.common.base.Supplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

public final class MoreSuppliers {
    private MoreSuppliers() {
    }

    public static <T> Supplier<T> of(final Class<? extends T> type) {
        Preconditions.checkNotNull(type);
        try {
            final Constructor<? extends T> constructor = MoreSuppliers.getNoArgConstructor(type);
            return new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        throw MoreSuppliers.instantiationFailed(e, type);
                    }
                    catch (IllegalAccessException e) {
                        throw MoreSuppliers.instantiationFailed(e, type);
                    }
                    catch (InvocationTargetException e) {
                        throw MoreSuppliers.instantiationFailed(e, type);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No accessible no-arg constructor for " + type, e);
        }
    }

    private static RuntimeException instantiationFailed(Exception cause, Object type) {
        return new RuntimeException("Could not create a new instance of type: " + type, cause);
    }

    private static <T> Constructor<T> getNoArgConstructor(Class<T> type) throws NoSuchMethodException {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            if (!MoreSuppliers.class.getPackage().equals(type.getPackage()) && !Modifier.isPublic(type.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Constructor<T> declaredConstructor = type.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
    }

    public static <T> Supplier<T> ofInstance(final @Nullable T item) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return item;
            }
        };
    }
}

