/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.logging;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

public class ResourceLoggingConfigurator {
    public static final String LOGGING_PROPERTIES_RESOURCE_PATH = "java.util.logging.config.resource";

    public ResourceLoggingConfigurator() throws IOException {
        String loggingPropertiesResourcePath = System.getProperty(LOGGING_PROPERTIES_RESOURCE_PATH, "/logging.properties");
        InputStream loggingConfig = this.getClass().getResourceAsStream(loggingPropertiesResourcePath);
        Preconditions.checkNotNull((Object)loggingConfig, (String)"Could not locate logging config file at resource path: %s", (Object[])new Object[]{loggingPropertiesResourcePath});
        LogManager.getLogManager().readConfiguration(loggingConfig);
    }
}

