/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.servlets;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.json.HealthCheckModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthCheckServlet
extends HttpServlet {
    public static final String HEALTH_CHECK_REGISTRY = HealthCheckServlet.class.getCanonicalName() + ".registry";
    public static final String HEALTH_CHECK_EXECUTOR = HealthCheckServlet.class.getCanonicalName() + ".executor";
    private static final long serialVersionUID = -8432996484889177321L;
    private static final String CONTENT_TYPE = "application/json";
    private transient HealthCheckRegistry registry;
    private transient ExecutorService executorService;
    private transient ObjectMapper mapper;

    public HealthCheckServlet() {
    }

    public HealthCheckServlet(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    public void init(ServletConfig config) throws ServletException {
        Object executorAttr;
        if (null == this.registry) {
            Object registryAttr = config.getServletContext().getAttribute(HEALTH_CHECK_REGISTRY);
            if (registryAttr instanceof HealthCheckRegistry) {
                this.registry = (HealthCheckRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a HealthCheckRegistry instance.");
            }
        }
        if ((executorAttr = config.getServletContext().getAttribute(HEALTH_CHECK_EXECUTOR)) instanceof ExecutorService) {
            this.executorService = (ExecutorService)executorAttr;
        }
        this.mapper = new ObjectMapper().registerModule((Module)new HealthCheckModule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SortedMap<String, HealthCheck.Result> results = this.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (results.isEmpty()) {
            resp.setStatus(501);
        } else if (HealthCheckServlet.isAllHealthy(results)) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        ServletOutputStream output = resp.getOutputStream();
        try {
            this.getWriter(req).writeValue((OutputStream)output, results);
        }
        finally {
            output.close();
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private SortedMap<String, HealthCheck.Result> runHealthChecks() {
        if (this.executorService == null) {
            return this.registry.runHealthChecks();
        }
        return this.registry.runHealthChecks(this.executorService);
    }

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public static abstract class ContextListener
    implements ServletContextListener {
        protected abstract HealthCheckRegistry getHealthCheckRegistry();

        protected ExecutorService getExecutorService() {
            return null;
        }

        public void contextInitialized(ServletContextEvent event) {
            ServletContext context = event.getServletContext();
            context.setAttribute(HEALTH_CHECK_REGISTRY, (Object)this.getHealthCheckRegistry());
            context.setAttribute(HEALTH_CHECK_EXECUTOR, (Object)this.getExecutorService());
        }

        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

