/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import com.twitter.common.collections.Pair;

public class ParsingUtil {
    public static Pair<Integer, Integer> parseRange(String rangeString) {
        int end;
        int start;
        if (rangeString == null) {
            return null;
        }
        String[] startEnd = rangeString.split("-");
        Preconditions.checkState((startEnd.length == 2 ? 1 : 0) != 0, (Object)"Shard range format: start-end (e.g. 1-4)");
        try {
            start = Integer.parseInt(startEnd[0].trim());
            end = Integer.parseInt(startEnd[1].trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse shard range.", e);
        }
        Preconditions.checkState((start <= end ? 1 : 0) != 0, (Object)"The left-hand side of a shard range must be <= the right-hand side.");
        return Pair.of((Object)start, (Object)end);
    }
}

