/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;

class CodahaleOpStatsLogger
implements OpStatsLogger {
    final Timer success;
    final Timer fail;

    CodahaleOpStatsLogger(Timer success, Timer fail) {
        this.success = success;
        this.fail = fail;
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        this.fail.update(eventLatency, unit);
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        this.success.update(eventLatency, unit);
    }

    public void registerSuccessfulValue(long value) {
        this.success.update(value, TimeUnit.MILLISECONDS);
    }

    public void registerFailedValue(long value) {
        this.fail.update(value, TimeUnit.MILLISECONDS);
    }

    public synchronized void clear() {
    }

    public synchronized OpStatsData toOpStatsData() {
        long numFailed = this.fail.getCount();
        long numSuccess = this.success.getCount();
        Snapshot s = this.success.getSnapshot();
        double avgLatencyMillis = s.getMean();
        double[] defaultPercentiles = new double[]{10.0, 50.0, 90.0, 99.0, 99.9, 99.99};
        long[] latenciesMillis = new long[defaultPercentiles.length];
        Arrays.fill(latenciesMillis, Long.MAX_VALUE);
        for (int i = 0; i < defaultPercentiles.length; ++i) {
            latenciesMillis[i] = (long)s.getValue(defaultPercentiles[i] / 100.0);
        }
        return new OpStatsData(numSuccess, numFailed, avgLatencyMillis, latenciesMillis);
    }
}

