/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.NumberFormat;

public class Stat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double _max = 0.0;
    private double _min = Double.MAX_VALUE;
    private long _number = 0L;
    private double _mean = 0.0;
    private double _stdDev = 0.0;
    private double _sum = 0.0;
    private double _sumOfSq;

    public void addNumber(int x) {
        this.addNumber((double)x);
    }

    public void addNumber(float x) {
        this.addNumber((double)x);
    }

    public synchronized void addNumber(double x) {
        if (this._max < x) {
            this._max = x;
        }
        if (this._min > x) {
            this._min = x;
        }
        this._sum += x;
        this._sumOfSq += x * x;
        ++this._number;
    }

    public void clear() {
        this._max = 0.0;
        this._min = Double.MAX_VALUE;
        this._number = 0L;
        this._mean = 0.0;
        this._stdDev = 0.0;
        this._sum = 0.0;
        this._sumOfSq = 0.0;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean percent) {
        this.calculate();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        if (this._number > 1L) {
            StringBuffer results = new StringBuffer();
            if (percent) {
                results.append("Number:" + nf.format(this._number * 100L) + "%");
            } else {
                results.append("Number:" + nf.format(this._number));
            }
            if (percent) {
                results.append(" Max:" + nf.format(this._max * 100.0) + "%");
            } else {
                results.append(" Max:" + nf.format(this._max));
            }
            if (percent) {
                results.append(" Min:" + nf.format(this._min * 100.0) + "%");
            } else {
                results.append(" Min:" + nf.format(this._min));
            }
            if (percent) {
                results.append(" Mean:" + nf.format(this._mean * 100.0) + "%");
            } else {
                results.append(" Mean:" + nf.format(this._mean));
            }
            results.append(" Sum:" + nf.format(this._sum));
            results.append(" STD:" + nf.format(this._stdDev));
            return results.toString();
        }
        if (this._number == 1L) {
            if (percent) {
                return "Number:" + nf.format(this._sum * 100.0) + "%";
            }
            return "Number:" + nf.format(this._sum);
        }
        return "Number: N/A";
    }

    private void calculate() {
        this.getMean();
        this.getStandardDev();
    }

    public double getMax() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public long getNumberOfElements() {
        return this._number;
    }

    public double getMean() {
        if (this._number > 0L) {
            this._mean = this._sum / (double)this._number;
        }
        return this._mean;
    }

    public double getPercent() {
        if (this._number > 0L) {
            this._mean = this._sum / (double)this._number;
        }
        this._mean *= 100.0;
        return this._mean;
    }

    public double getSum() {
        return this._sum;
    }

    public double getSumOfSq() {
        return this._sumOfSq;
    }

    public double getStandardDev() {
        if (this._number > 1L) {
            this._stdDev = Math.sqrt((this._sumOfSq - this._sum * this._sum / (double)this._number) / (double)(this._number - 1L));
        }
        return this._stdDev;
    }

    public void readFromDataInput(InputStream in) throws IOException {
        DataInputStream di = new DataInputStream(in);
        this.readFromDataInput(di);
    }

    public void readFromDataInput(DataInput in) throws IOException {
        this._max = in.readDouble();
        this._min = in.readDouble();
        this._number = in.readLong();
        this._mean = in.readDouble();
        this._stdDev = in.readDouble();
        this._sum = in.readDouble();
        this._sumOfSq = in.readDouble();
    }

    public void writeToDataOutput(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        this.writeToDataOutput(dout);
    }

    public void writeToDataOutput(DataOutput out) throws IOException {
        out.writeDouble(this._max);
        out.writeDouble(this._min);
        out.writeLong(this._number);
        out.writeDouble(this._mean);
        out.writeDouble(this._stdDev);
        out.writeDouble(this._sum);
        out.writeDouble(this._sumOfSq);
    }
}

