/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

public class RangeNormalizer {
    private double _denominator;
    private double _B;
    private double _minA = Double.MIN_VALUE;
    private double _maxA = Double.MAX_VALUE;
    private double _minB = Double.MIN_VALUE;
    private double _maxB = Double.MAX_VALUE;
    private double _midB = Double.MAX_VALUE;

    public RangeNormalizer(double minA, double maxA, double minB, double maxB) {
        this._minA = minA;
        this._maxA = maxA;
        this._minB = minB;
        this._maxB = maxB;
        this._denominator = this._maxA - this._minA;
        this._B = this._maxB - this._minB;
        this._midB = minB + this._B / 2.0;
    }

    public double normalize(double value) {
        if (this._denominator == 0.0) {
            return this._midB;
        }
        return (value - this._minA) / this._denominator * this._B + this._minB;
    }

    public static double normalize(double value, double minA, double maxA, double minB, double maxB) {
        if (minA == maxA) {
            return minB;
        }
        return (value - minA) / (maxA - minA) * (maxB - minB) + minB;
    }

    public static float normalizeToStepDistribution(double rating) {
        int integerRating = (int)Math.round(rating);
        if (integerRating == 2) {
            integerRating = 1;
        } else if (integerRating == 4) {
            integerRating = 3;
        } else if (integerRating == 6) {
            integerRating = 5;
        } else if (integerRating == 8) {
            integerRating = 7;
        } else if (integerRating == 9) {
            integerRating = 10;
        }
        return integerRating;
    }
}

